# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# Module that creates the listing of the assertions/clauses 
#********************************************************#


# Import various constants
from definitions import *

# Import procedures
from procedure import *


#********************************************************#
# Class that creates listing of facts/clauses/queries
#********************************************************#
class AssertionsClass:

  "Class that create Table with fact and queries "

  
  #********************************************************************************************
  # Initialization of internal data structures
  #********************************************************************************************
  def __init__(self):
    self.data = []

  #********************************************************************************************
  # Procedure that creates assertions from the "tree" graph by appling the conversion rules
  #********************************************************************************************
  def create_assertions(self, tree, explode):
    tmp = []
    # CONTAINER IN SUBJECT
    if tree[0] in CONTAINER:
      # CONTAINER IN SUBJECT AND OBJECT
      if tree[3] in CONTAINER:
        if explode == '1':
          list_ok1 = buid_list_cont(tree[0],tree[1])
          list_ok2 = buid_list_cont(tree[3],tree[4])
        else:
          list_ok1 = buid_list_cont1(tree[0],tree[1])
          list_ok2 = buid_list_cont1(tree[3],tree[4])          
        u1 = 0
        tmp1 = []
        while u1 < len(list_ok1):
          u2 = 0
          while u2<len(list_ok2):          
            temp = (tree[2]+"("+str(list_ok1[u1])+","+str(list_ok2[u2])+")")
            tmp1.append(temp)
            u2 = u2+1
          u1 = u1+1

        self.data = (tmp1, tree[0], tree[3])

      # CONTAINER IN SUBJET AND MATH OP IN THE OBJECT
      elif riconosci_op(tree[3]) in MATH:
        if explode == '1':
          list_ok = buid_list_cont(tree[0], tree[1])
        else:
          list_ok = buid_list_cont1(tree[0], tree[1])
        stringa = op_math(riconosci_op(tree[3]), tree[4],0)
        if stringa != -1:
          l = 0
          tmp2 = []
          while l < len(list_ok):
            temp = (tree[2]+"('"+str(list_ok[l])+"',A):-(A is ("+stringa+"))")
            tmp2.append(temp)
            l=l+1
          self.data = (tmp2, "assertions")
        else:
          self.data = [-1]

      # CONTAINER ONLY IN SUBJECT
      else:
        if explode == '1':
          list_ok = buid_list_cont(tree[0], tree[1])
        else:
          list_ok = buid_list_cont1(tree[0], tree[1])
        u = 0
        tmp1 = []
        while u < len(list_ok):
          obj = check_var(tree[3])
          obj = check_num(obj)
          temp = (tree[2]+"("+str(list_ok[u])+","+obj+")")
          tmp1.append(temp)
          u = u+1
        self.data = (tmp1, tree[0])
    
    # LOGICAL OPERATORS
    elif tree[0] in LOGIC:

      # "AND" LOGICAL OPERATOR
      if tree[0] == "and":

        if checkdip(tree[1:len(tree)]): # if there are no dependencies ...
  
          r=0
          out=[]
          max = len(tree)-1
          while r < max:

            sub_assertions = AssertionsClass()
            sub_assertions.create_assertions(tree[r+1], explode)
            out_assertions = sub_assertions.data
            del sub_assertions

            if out_assertions==[-1]:
              print("Information loss, fact/clause not analyzable.")
              self.data = [-2]
            else:
              if type(out_assertions) == TYPETUPLE:
                out_assertions = out_assertions[0]
              out = out+out_assertions
            r=r+1 
          self.data = (out, "and")

        else: # if there are dependencies ...
          max = len(tree)-1
          r=0
          out=[]
          out1 = ''
          while r < max-1:

            sub_assertions = AssertionsClass()
            sub_assertions.create_assertions(tree[r+1], explode)
            out_assertions = sub_assertions.data
            del sub_assertions

            if out_assertions==[-1]:
              print("Information loss, fact/clause not analyzable.")
              self.data = [-2]
            else:
              if type(out_assertions) == TYPETUPLE:
                out_assertions = out_assertions[0]
#              out = out+out_assertions
              out1 = out1 + out_assertions[0] + ','
            r=r+1
          
          sub_assertions = AssertionsClass()
          sub_assertions.create_assertions(tree[r+1], explode)
          out_assertions = sub_assertions.data
          del sub_assertions

          if out_assertions==[-1]:
            print("Information loss, fact/clause not analyzable.")
            self.data = [-2]
          else:
            if type(out_assertions) == TYPETUPLE:
              out_assertions = out_assertions[0]
  #           out = out+out_assertions
            out1 = out1 + out_assertions[0] 
          
          self.data = ([out1], "and")
        
    
      # "OR" LOGICAL OPERATOR
      if tree[0] == "or":
 
        max = len(tree)-1
        r = 0
        out = []
        out1 = ''
        while r < max-1:

          sub_assertions =AssertionsClass()
          sub_assertions.create_assertions(tree[r+1], explode)
          out_assertions = sub_assertions.data
          del sub_assertions

          if out_assertions == [-1]:
            print("Information loss, fact/clause not analyzable.")
            self.data = [-3]
          else:
            if type(out_assertions) == TYPETUPLE:
              out_assertions = out_assertions[0]
#            out = out+out_assertions
            out1 = out1 + out_assertions[0] + ';'
          r = r+1

        sub_assertions = AssertionsClass()
        sub_assertions.create_assertions(tree[r+1], explode)
        out_assertions = sub_assertions.data
        del sub_assertions

        if out_assertions == [-1]:
          print("Information loss, fact/clause not analyzable.")
          self.data = [-3]
        else:
          if type(out_assertions) == TYPETUPLE:
            out_assertions = out_assertions[0]
#            out = out+out_assertions
          out1 = out1 + out_assertions[0]

        self.data = ([out1], "or")

      # "NOT" LOGICAL OPERATOR
      if tree[0] == "not":
        sub_assertions = AssertionsClass()
        sub_assertions.create_assertions(tree[1], explode)
        list_not = sub_assertions.data
        del sub_assertions

        if list_not == [-1]:
          print("Information loss, fact/clause not analyzable.")
          self.data = [-4]
        else:
          tmp_list_not = []
          u = 0
          while u < len(list_not)-1:
            if list_nots[u][0] == [-1]:
              print("Information loss, fact/clause not analyzable.")
              self.data = [-5]
            tmp_list_not.append("not("+list_not[u][0]+")")
            u = u+1
          self.data = (tmp_list_not, "not")
  
      # "IMPLY" LOGICAL OPERATOR
      if tree[0] == "implies":

        sub_assertions = AssertionsClass()
        sub_assertions.create_assertions(tree[1], explode)
        first_list = sub_assertions.data
        del sub_assertions

        sub_assertions = AssertionsClass()
        sub_assertions.create_assertions(tree[2], explode)
        second_list = sub_assertions.data
        del sub_assertions

        # Data lost in at least one of the two imply operators
        if first_list == [-1] or second_list == [-1]:
          print("Information loss, fact/clause not analyzable.")
          self.data = [-6]

        # ASSERTIONS=>ASSERTIONS
        elif first_list[1] in ("assertions", "not") and second_list[1] in ("assertions", "not"):
          tmp = [first_list[0][0]+":-("+second_list[0][0]+")"]

        # CONTAINER=>ASSERTIONS
        elif first_list[1] in ("assertions", "not") and second_list[1] in CONTAINER:
          u = 0
          tmp = []
          while u < len(second_list[0]):
            tmp.append(first_list[0][0]+":-("+second_list[0][u]+")")
            u = u+1

        # ASSERTIONS= > CONTAINER
        elif first_list[1] in CONTAINER and second_list[1] in ("assertions", "not"):
          u = 0
          tmp = []
          while u < len(first_list[0]):
            tmp.append(first_list[0][u]+":-("+second_list[0][0]+")")
            u = u+1

        # CONT=>CONT
        elif first_list[1] in CONTAINER and second_list[1] in CONTAINER:
          u = 0
          tmp = []
          while u < len(first_list[0]):
            j = 0
            while j < len(second_list[0]):
              tmp.append(first_list[0][u]+":-("+second_list[0][j]+")")
              j = j+1
            u = u+1

        # (ASSERTIONS or ASSERTIONS)=> ASSERTIONS
        elif first_list[1] in ("assertions", "not") and second_list[1] == "or":

          if checkdip(tree[2]): # if there are not dependencies ...
            # We have to compute the list of assertions 'put in logical or' as the procedure
            # that computes the relative assertions does not split them
            stringa = second_list[0][0]
            lst_tmp = []
            fine = 1
            while fine: # reconstruction of the list of single assertions
              n = find_char_norm(stringa,';')
              if n != -1:
                lst_tmp.append(stringa[0:n])
                stringa = stringa[n+1:len(stringa)]
              else:
                lst_tmp.append(stringa)
                fine = 0
            
            tmp = []            
            for el in lst_tmp:
              tmp.append(first_list[0][0]+":-("+el+")") 
          else:
            tmp = [first_list[0][0]+":-"+second_list[0][0]]              
 
        # ASSERTIONS => (ASSERTIONS or ASSERTIONS) : possible data loss
        elif first_list[1] == "or" and second_list[1] in ("assertions", "not"):

          tmp = [first_list[0][0]+":-"+second_list[0][0]]              


        # (ASSERTIONS and ASSERTIONS)=> ASSERTIONS  : possible data loss
        elif first_list[1] in ("assertions", "not") and second_list[1] == "and":

          # We have to compute the list of assertions 'put in logical and' as the procedure
          # that computes the relative assertions might not have split them
          
          lst_tmp = []
          for stringa in second_list[0]:
            fine = 1
            while fine: # reconstruction of the list of single assertions
              n = find_nextand(stringa) # look for  '),' in the string
              if n != -1:
                lst_tmp.append(stringa[0:n])
                stringa = stringa[n+1:len(stringa)]
              else:
                lst_tmp.append(stringa)
                fine = 0
                
          str_t = lst_tmp[0]
          for el in lst_tmp[1:len(lst_tmp)]:
            str_t = str_t + ',' + el
            
          tmp = [first_list[0][0]+":-("+str_t+")"] 
 
        # ASSERTIONS => (ASSERTIONS and ASSERTIONS)  
        elif first_list[1] == "and" and second_list[1] in ("assertions", "not"):

          # We have to compute the list of assertions 'put in logical and' as the procedure
          # that computes the relative assertions might not have split them
          
          lst_tmp = []
          for stringa in first_list[0]:
            fine = 1
            while fine: # reconstruction of the list of single assertions
              n = find_nextand(stringa) # look for  '),' in the string
              if n != -1:
                lst_tmp.append(stringa[0:n])
                stringa = stringa[n+1:len(stringa)]
              else:
                lst_tmp.append(stringa)
                fine = 0
                
          if checkdip(tree[1]): # if there are no dependencies ...
            tmp = []
            for el in lst_tmp:
              tmp.append(el+":-"+second_list[0][0])
              
          else: # if there are dependencies put all within a row
                # sure loss of data
            str_t = lst_tmp[0]
            for el in lst_tmp[1:len(lst_tmp)]:
              str_t = str_t + ',' + el
            tmp =["("+str_t+"):-"+second_list[0][0]]

            
        # (ASSERTIONS or ASSERTIONS) => CONTAINER
        elif first_list[1] in CONTAINER and second_list[1] == "or":

          if checkdip(tree[2]+tree[1]): # if there are no dependencies ...
            # We have to compute the list of assertions 'put in logical or' as the procedure
            # that computes the relative assertions does not split them
            stringa = second_list[0][0]
            lst_tmp = []
            fine = 1
            while fine: # reconstruction of the list of single assertions
              n = find_char_norm(stringa,';')
              if n != -1:
                lst_tmp.append(stringa[0:n])
                stringa = stringa[n+1:len(stringa)]
              else:
                lst_tmp.append(stringa)
                fine = 0
            
            tmp = []            
            u = 0
            while u < len(lst_tmp):
              y = 0
              while y < len(first_list[0]):
                tmp.append(first_list[0][y]+":-("+lst_tmp[u]+")") 
                y = y+1
              u = u+1

          else: # If there are dependencies put everything in a string

            str_cont = first_list[0][0]
            for el in first_list[0][1:len(first_list[0])]:
              str_cont = str_cont + ',' + el
              
            str_or = first_list[0][0]
              
            tmp = ['('+str_cont+'):-('+str_or+')']

              

        # CONTAINER => (ASSERTIONS and ASSERTIONS)   
        elif first_list[1] == "and" and second_list[1] in CONTAINER:

          # We have to compute the list of assertions 'put in logical and' as the procedure
          # that computes the relative assertions might not have split them
          
          lst_tmp = []
          for stringa in first_list[0]:
            fine = 1
            while fine: # reconstruction of the list of single assertions
              n = find_nextand(stringa) # cerca '),' nella stringa
              if n != -1:
                lst_tmp.append(stringa[0:n])
                stringa = stringa[n+1:len(stringa)]
              else:
                lst_tmp.append(stringa)
                fine = 0
                
          if checkdip(tree[1]+tree[2]): # if there are no dependencies ...
            u = 0
            tmp = []
            while u < len(lst_tmp):
              y = 0
              while y < len(second_list[0]):
                tmp.append(first_list[0][u]+":-("+second_list[0][y]+")")
                y = y+1
              u = u+1
              
          else: # if there are dependencies put everything within a row
                # sure loss of data

            str_cont = second_list[0][0]
            for el in second_list[0][1:len(second_list[0])]:
              str_cont = str_cont + ',' + el
              
            str_and = lst_tmp[0]
            for el in lst_tmp[1:len(lst_tmp)]:
              str_and = str_and + ',' + el
              
            tmp = ['('+str_and+'):-('+str_cont+')']
            
 
        # PRED CONFR=>ASSERTIONS
        elif first_list[1] in ("assertions", "not") and second_list[1] in PRED_CONFR:
          tmp = [first_list[0][0]+":-("+second_list[0][0]+")"]

        # LOSS OF DATA
        else:
          print("Attention, Loss of Data")
          self.data = [-7]

        # Save data
        self.data = (tmp, "implies")
 

    # COMPARISON PREDICATES
    elif riconosci_op(tree[0]) in PRED_CONFR:

      # handle inequality operators
      stri_t = riconosci_op(tree[0])
      if stri_t == "eq":
          confr = "=:="
      elif stri_t == "neq":
        confr = "=\="
      elif stri_t == "less":
        confr = "<"
      elif stri_t == "great":
        confr = ">"
      elif stri_t == "leq":
        confr = "=<"
      elif stri_t == "geq":
        confr = ">="

      num1 = tree[1]
      num2 = tree[2]
 
      if type(num1)==TYPELIST:
        if num1[0] == 'var':
          num1 = num1[1]
        elif riconosci_op(num1[0]) in MATH:
          stringa = op_math(riconosci_op(num1[0]), num1[1], 0)
          num1 = stringa
      else: # take away quote:number
        num1=num1[1:len(num1)-1]

      if type(num2)==TYPELIST:
        if num2[0] == 'var':
          num2 = num2[1]
        elif riconosci_op(num2[0]) in MATH:
          stringa = op_math(riconosci_op(num2[0]), num2[1], 0)
          num2 = stringa
      else: # take away quote:number
        num2=num2[1:len(num2)-1]

      
      self.data = [num1+confr+num2], riconosci_op(tree[0])
      
    # MATH OPERATORS
    elif riconosci_op(tree[2]) in MATH:
      stringa = op_math(riconosci_op(tree[2]), tree[3], 0)
      if stringa != -1:
        sub = check_var(tree[0])
        sub = check_num(sub)
        temp = (tree[1]+"("+sub+",A):-(A is ("+stringa+"))")
        tmp.append(temp)
        self.data = (tmp, "assertions")

      else:
        self.data = [-8]

    # CONTAINER ONLY IN OBJECT
    elif tree[2] in CONTAINER:
      if explode == '1':
        list_ok = buid_list_cont(tree[2], tree[3])
      else:
        list_ok = buid_list_cont1(tree[2], tree[3])
      u = 0
      tmp = []
      while u < len(list_ok):
        sub = check_var(tree[0])
        sub = check_num(sub)
        temp = (tree[1]+"("+sub+","+str(list_ok[u])+")")
        tmp.append(temp)
        u = u+1
      self.data = (tmp, tree[2])    

    # SIMPLE ASSERTION
    else:
      sub = check_var(tree[0])
      obj = check_var(tree[2])
      sub = check_num(sub)
      obj = check_num(obj)
      temp = (tree[1]+"("+sub+","+obj+")")
      tmp.append(temp)
      self.data = (tmp, "assertions")


  
#********************************************************************************************
# Auxiliary procedures needed by the AssertionsClass class

#********************************************************************************************
# Procedure that checks if the subject and object are numbers. If so, returns the number without quotes.
#********************************************************************************************
def check_num(stringa):
  if len(stringa) > 4:
    tmp = stringa[2:len(stringa)-2]    
    for char in tmp:
      if not(char in NUMERI):
        return(stringa)
    return(tmp)
  else:
    return(stringa)
  

#********************************************************************************************
# Procedure that returns all the possible permutations of the input list
#********************************************************************************************
def permut(lista):
  if len(lista)==2:
    return([(lista[0],lista[1]),(lista[1],lista[0])])
  else:
    l=0
    tmp=[]

    while l<len(lista):  
      u=0
      ric=permut(lista[0:l]+lista[l+1:len(lista)])
      
      while(u<len(ric)):
        tmp.append(ric[u]+tuple([lista[l]]))
        u=u+1
      l=l+1
    return(tmp)
  

#********************************************************************************************
# Procedure that builds the list of the elements of a container
#********************************************************************************************
def buid_list_cont(treea, treeb):
  if treea=="bag":    # Permutation of all the elements
    list_ok=permut(treeb)
    y=0
    list_ok2=[]
    while y<len(list_ok):
      bb=list_ok[y]
      p=1
      list_ok1=[]
      if bb[0][0]=="var":
        tmp=bb[0][1]
        list_ok1s="["+str(tmp)
      else:
        list_ok1s="['"+str(bb[0])+"'"
      while p<len(bb):
        if bb[p][0]=="var":
          tmp=bb[p][1]
          list_ok1s=list_ok1s+", "+str(tmp)
        else:
          list_ok1s=list_ok1s+", '"+str(bb[p])+"'"
        p=p+1
      list_ok2.append(list_ok1s+"]")
      y=y+1
    list_ok=list_ok2
    
  elif treea=="seq":  # Simple sequence of the elements
    if treeb[0][0]=="var":
      tmp=treeb[0][1]
      list_tmp="["+str(tmp)
    else:
      list_tmp="['"+str(treeb[0])+"'"
    y=1
    while y<len(treeb):
      if treeb[y][0]=="var":
        tmp=treeb[y][1]
        list_tmp=list_tmp+", "+str(tmp)
      else:
        list_tmp=list_tmp+", '"+str(treeb[y])+"'"
      y=y+1

    list_ok=[list_tmp+"]"]

    
  elif treea=="alt":  # ALTernatives of the elements
    y=0
    list_tmp=[]
    while y<len(treeb):
      if treeb[y][0]=="var":
        tmp=treeb[y][1]
        list_tmp.append(str(tmp))
      else:
        list_tmp.append(str(treeb[y]))
      y=y+1

    list_ok=list_tmp

  return(list_ok)


#********************************************************************************************
# Procedure that builds the first elements relative to the list of the elements of the container
#********************************************************************************************
def buid_list_cont1(treea, treeb):
  if treeb[0][0]=="var":
    tmp=treeb[0][1]
    list_tmp="["+str(tmp)
  else:
    list_tmp="['"+str(treeb[0])+"'"
  y=1
  while y<len(treeb):
    if treeb[y][0]=="var":
      tmp=treeb[y][1]
      list_tmp=list_tmp+", "+str(tmp)
    else:
      list_tmp=list_tmp+", '"+str(treeb[y])+"'"
    y=y+1
    
  list_ok=[list_tmp+"]"]
  return(list_ok)



#********************************************************************************************
# Procedure that builds a string from the math op
#********************************************************************************************
def op_math(type,lista,i):
  if type=="add":
    op="+"
  elif type=="divide":
    op="/"      
  elif type=="sub":
    op="-"            
  elif type=="times":
    op="*"
  else:
    return(-1)
  if (riconosci_op(lista[0][0]) in MATH):
    stringa1=op_math(riconosci_op(lista[0][0]),lista[0][1],i+1)
  else:
    stringa1=lista[0][1:len(lista[0])-1]
  if (riconosci_op(lista[1][0]) in MATH):
    stringa2=op_math(riconosci_op(lista[1][0]),lista[1][1],i+1)
  else:
    stringa2=lista[1][1:len(lista[1])-1]
 
  stri="("+stringa1+op+stringa2+")"
  return(stri)


#********************************************************************************************
# Procedure that builds a list from a tuple or a string
#********************************************************************************************
def create_list(element):
  if type(element)==TYPELIST:
    return(element)
  elif type(element)==TYPESTRING:
    return([element])
  elif type(element)==TYPETUPLE:
    i=0
    tmp=[]
    while i<len(element):
      tmp.append(element[i])
      i=i+1
  else:
    print("Error in data")
    return([])


#********************************************************************************************
# Procedure that checks if the element of an assertion is a Variable; if so, takes away the quotes
#********************************************************************************************
def check_var(stringa):
  if stringa[0]=="var":
    return(stringa[1])
  else:
    return("'"+stringa+"'")


#********************************************************************************************
# Procedure that returns the list of variables container in an assertion
#********************************************************************************************
def containvar(stringa):
  tmp = []
  if type(stringa)==TYPELIST:
    if len(stringa)==2:
      if stringa[0]=='var':
        tmp = tmp+ [stringa[1]]
      else:
        for el_str in stringa:
          if type(el_str)==TYPELIST:
            tmp = tmp + containvar(el_str)
        
          #  tmp = tmp + containvar(stringa)      
    elif len(stringa)>2:
      for el_str in stringa:
        if type(el_str)==TYPELIST:
          tmp = tmp + containvar(el_str)
  return(tmp)


#********************************************************************************************
# Procedure that checks the dependencies of the variables in a list
#********************************************************************************************
def checkdip(tree):
  insiemetmp = []
  checkdip = 1        
  for el in tree:
    lista_var = containvar(el)
    for elvar in lista_var:
      if not(elvar in insiemetmp):
        insiemetmp.append(elvar)
      else:
        checkdip= 0

  return(checkdip)


#********************************************************************************************
# Look for the char sequence  '),' in a string
#********************************************************************************************
def find_nextand(stringa):
  n = find_char_norm(stringa,',')
  if n == -1:
    return(-1)
  elif stringa[n-1] == ')':
    return(n)
  else:
    somma = n + 1
    str_tmp = stringa
    while n!=-1 and str_tmp[n-1]!=')':
      str_tmp = str_tmp[n+1:len(str_tmp)]
      n = find_char_norm(str_tmp,',')
      somma = somma + n + 1
    if n==-1:
      return(-1)
    else:
      return(somma-1)    
    
    


