# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
# Module that handles the translation to N-Triples

# This module defines the -Triple- class
# used to build the triples
# given as input the encoded discourse tree



if 'cost' in dir():  # import cost module
    reload(cost)
else: import cost

RDF=cost.RDF_NS
ML=cost.METALOG_NS
NML=cost.METALOG_NOT_NS
MML=cost.METALOG_MATH_NS

# Class used to build the triples
# received the tree (instance of the Parser class) as input,
# uses the adopted conventions for the N-triples output
class Triple:

    # class constructor
    # T = instance of the Parser class (parser module)
    # F = instance of the File class (file module)
    def __init__(self,T,F):
        self.F=F
        self.T=T
        self.treeIn=T.returnListTree()
        self.stringOut=''
        self.numAnon=0 #global variable, increased each time for anonymous nodes
        self.listTriple=[]
        self.addComment('N-Triple generated with ' +cost.VER_TRANS) 
        


    # 25/4/02 built
    # takes a string in input
    # and gets back the string appropriately modified 
    # to satisfy the escaping chars of the N-Triples
    def escaping(self,stringIn):
        stringIn=stringIn.replace('\\','\\\\')         # maintan the sbstitution order
        stringIn=stringIn.replace('"','\\"')
        # if the case, we can add the other escaping chars of the N-triples...
        return stringIn
    

    # returns the id for a new anonymous node
    def newAn(self):
        self.numAnon+=1
        return '_:an'+str(self.numAnon)

    #returns the Out of the N-Triples
    def saveToFileOut(self):
        for triple in  self.listTriple:
            if len(triple)==3:  #triple
                self.stringOut+= '\n'+ ' '*3+ '\n' + triple[0] + '\n'+ triple[1] + '\n' + triple[2] + '.' 
            elif len(triple)==1: #comment
                self.stringOut+= triple[0]
        return self.stringOut

    #take away all the comments (if any) present in the list
    #(used to comment on the triples)
    # and gets back the triples only
    def returnOnlyTriple(self):
        tmp=[]
        for triple in self.listTriple:
            if len(triple)==3:
                tmp.append(triple)
        return tmp
            
 
    # adds a new triple to the triple list
    # subj = subject of the triple
    # pred = predicate of the triple
    # obj = object of the triple
    def addTriple(self,subj,pred,obj):
         self.listTriple.append([subj,pred,obj])
    # add a comment to the triple list
    # string = comment string
    def addComment(self,string):
         self.listTriple.append(['# '+string])

    # add a white line
    # to the triple list
    def addBlankLine(self):
         self.listTriple.append(['\n'])


    # gets back the input file name
    def nameFileIn(self):
        return self.F.idFileOut().name


    # gets back the output file name
    def nameFileOut(self):
        return self.F.idFileOut().name

    
    # main method used to create the triples 
    # returns as output the triples as a string
    def createTriple(self):
        self.treeIn.remove('discourse')
        for elem in self.treeIn:
        #    self.addComment('Statement:')            
            self.toTriple(elem)
        self.saveToFileOut()
        return  self.stringOut 


    # calls the opportune method for each kind of element
    # elem = element
    # if reif='reif' returns the reification
    # of the assertion
    def toTriple(self,elem,reif='n'):
        if elem[0] == 'stat' and reif=='n':
             return self.retStat(elem)
        if elem[0] == 'stat' and reif=='reif':
             return self.retStatReif(elem)
        if elem[0] == 'Nstat':               
            return self.retNotStat(elem)
        if elem[0] == 'and':
            return self.retAnd(elem)
        if elem[0] == 'or':
            return self.retOr(elem)
        if elem[0] == 'imply':
            return self.retImply(elem)
        if elem[0] in ['eq','neq','less','great','leq','geq']:
            return self.retPred(elem)
        


    # handles the elements of type stat
    # calls the opportune method
    # for each kind of element
    # elem = element
    def elemStat(self,elem):
        if elem[0] == 'u':
            return self.retURI(elem)
        if elem[0] == 'q':
            return self.retString(elem)
        if elem[0] == 'v':
            return self.retVar(elem)
        if elem[0] == 'bag':
            return self.retBag(elem)
        if elem[0] == 'alt':
            return self.retAlt(elem)
        if elem[0] == 'seq':
            return self.retSeq(elem)
        if elem[0] in ['add','sub','times','divide']:
            return self.retOp(elem)       


    # given as input an element of the tree
    # of URI type, returns the URI itself
    def retURI(self,elem):
        return '<'+ elem[1] +'>'

    # given as input an element of the tree
    # of type string
    # returns the string (with quotes)
    def retString(self,elem):
        string= self.escaping(elem[1])
        return '"' + string + '"'
    
#        return '"' + elem[1] + '"'

    # given as input an element of the tree
    # of type Variable
    # creates new triples to identify it
    # returns the new anonymous node that identifies it
    def retVar(self,elem):
        an=self.newAn()
        self.addTriple(an,'<'+ML+'name>','"'+ elem[1] +'"')
        return(an)

    # given as input an element of the tree
    # of container type "bag"
    # creates new triple to identify it
    # returns the new anonymous node that identifies it
    def retBag(self,elem):
        elem.remove('bag')
        an=self.newAn()
        self.addBlankLine()
        self.addTriple(an,'<'+RDF+'type>','<'+RDF+'Bag>')
        i=0
        for e in elem:
            i+=1
            tmp=self.elemStat(e)
            self.addTriple(an,'<'+RDF+'_'+str(i) +'>',tmp)
        return(an)


    # given as input an element of the tree
    # of container type "Alt"
    # creates new triple to identify it
    # returns the new anonymous node that identifies it
    def retAlt(self,elem):
        elem.remove('alt')
        an=self.newAn()
        self.addBlankLine()
        self.addTriple(an,'<'+RDF+'type>','<'+RDF+'Alt>')
        i=0
        for e in elem:
            i+=1
            tmp=self.elemStat(e)
            self.addTriple(an,'<'+RDF+'_'+str(i) +'>',tmp)
        return(an)

    # given as input an element of the tree
    # of container type "Seq"
    # creates new triple to identify it
    # returns the new anonymous node that identifies it
    def retSeq(self,elem):
        elem.remove('seq')
        an=self.newAn()
        self.addBlankLine()
        self.addTriple(an,'<'+RDF+'type>','<'+RDF+'Seq>')
        i=0
        for e in elem:
            i+=1
            tmp=self.elemStat(e)
            self.addTriple(an,'<'+RDF+'_'+str(i)+'>',tmp)
        return(an)



    # given as input an element of the tree
    # of type Stat
    # creates new triple to identify it
    # returns the new anonymous node that identifies it
    def retStat(self,elem):
        posixOrigin=self.lastIndex()
        subj=self.elemStat(elem[1])
        pred=self.elemStat(elem[2])
        obj=self.elemStat(elem[3])
        self.addTriple(subj,pred,obj)
        self.lastInsertFrist(posixOrigin) #
        return subj


    # given as input an element of the tree
    # of type Stat
    # creates a new anonymous node
    # and the corresponding triples to identify
    # te reificationof that statement
    # returns the anonymous node that identifies the reification
    def retStatReif(self,elem):
        an=self.newAn()
        posixOrigin=self.lastIndex()
        subj=self.elemStat(elem[1])
        pred=self.elemStat(elem[2])
        obj=self.elemStat(elem[3])
        self.addTriple(an,'<'+RDF+'subject>',subj)
        self.addTriple(an,'<'+RDF+'predicate>',pred)
        self.addTriple(an,'<'+RDF+'object>',obj)
        self.addTriple(an,'<'+RDF+'type>','<'+RDF+'Statement>')
        self.lastInsertFrist(posixOrigin) #
        return an 

    # given as input an element of the tree
    # of type NotStat
    # creates new triples to identify it
    # returns the new anonymous node that identifies it
    def retNotStat(self,elem):
        an=self.newAn()
        tmp=self.retStatReif(elem)
        self.addTriple(an,'<'+ML+'operator>','<'+NML+'Not>')
        self.addTriple(an,'<'+RDF+'_1>',tmp)
        return(an)

    # given as input an element of the tree
    # of type "And"
    # creates new triples to identify it
    # returns the new anonymous node that identifies it
    def retAnd(self,elem):
        elem.remove('and')
        an=self.newAn()
       # self.addComment('and:')    
        self.addTriple(an,'<'+ML+'operator>','<'+ML+'And>')
        i=0
        for e in elem:
            i+=1
            self.addBlankLine()    
            posixOrigin=self.lastIndex() #to maintain the position
            tmp=self.toTriple(e,'reif')
            self.addTriple(an,'<'+RDF+'_'+str(i)+'>',tmp)
            self.lastInsertFrist(posixOrigin) #me
        return(an)



    # given as input an element of the tree
    # of type "Or"
    # creates new triples to identify it
    # returns the new anonymous node that identifies it
    def retOr(self,elem):
        elem.remove('or')
        an=self.newAn()
        #self.addComment('or:')    
        self.addTriple(an,'<'+ML+'operator>','<'+ML+'Or>')
        i=0
        for e in elem:
            i+=1
            self.addBlankLine()    
            posixOrigin=self.lastIndex() #to maintain the position
            tmp=self.toTriple(e,'reif')
            self.addTriple(an,'<'+RDF+'_'+str(i)+'>',tmp)
            self.lastInsertFrist(posixOrigin) #
        return(an)



    # given as input an element of the tree
    # of type "Imply"
    # creates new triples to identify it
    # returns the new anonymous node that identifies it
    def retImply(self,elem):
        an=self.newAn()
        self.addTriple(an,'<'+ML+'operator>','<'+ML+'Implies>')

        self.addBlankLine()    
        posixOrigin=self.lastIndex() #to maintain the position
        left=self.toTriple(elem[1],'reif')
        self.addTriple(an,'<'+RDF+'_1>',left)
        self.lastInsertFrist(posixOrigin) #puts the last element in position lastIndex

        self.addBlankLine()    
        posixOrigin=self.lastIndex() #to maintain the position
        right=self.toTriple(elem[2],'reif')
        self.addTriple(an,'<'+RDF+'_2>',right)
        self.lastInsertFrist(posixOrigin) #puts the last element in position lastIndex
        return(an)

    # creation triple for comparison predicates
    def retPred(self,elem):
        typeOp=elem[0]
        elem.remove(typeOp)
        an=self.newAn()
        self.addTriple(an,'<'+MML+'operator>','<'+MML+ typeOp +'>')
        i=0
        for e in elem:
            i+=1
            tmp=self.elemStat(e)
            self.addTriple(an,'<'+RDF+'_'+str(i) +'>',tmp)
        return(an)


    # given as input an element of the tree
    # of type math op
    # creates new triples to identify it
    # returns the new anonymous node that identifies it
    def retOp(self,elem):
        typeOp=elem[0]
        elem.remove(typeOp)
        an=self.newAn()
        #self.addComment('or:')    
        self.addTriple(an,'<'+MML+'operator>','<'+MML+ typeOp +'>')
        i=0
        for e in elem:
            i+=1
            tmp=self.elemStat(e)
            self.addTriple(an,'<'+RDF+'_'+str(i) +'>',tmp)
        return(an)



 
    # takes away the last element of the triples list
    # and insert it in the posix position
    def lastInsertFrist(self,posix):
        last=self.listTriple.pop()
        self.listTriple.insert(posix,last)


    # returns the index to the last element of the
    # triple list plus one
    def lastIndex(self):
       return len(self.listTriple) 
    
     
