# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# Module that implements the class to read data from a file and
# create the structure (tree) to analyze
#********************************************************#

import os

import time

# Import constants
from  definitions   import *
from  procedure     import *

# Import module creation assertions list
from  assertions    import AssertionsClass

# Import module creation queries list
from  queries       import QueriesClass


#********************************************************#
# Class that reads the data from file and creats the data
# structure (tree) to analyze
#********************************************************#
class TreeClass:

  "Class that create Tree"

  
  #********************************************************************************************
  # Initialization internal data structures
  #********************************************************************************************
  def __init__(self):
    self.data             = []
    self.data_ord         = []
    self.tree             = []
    self.elencoassertions = []

  #********************************************************************************************
  # Creation assertsions/clauses/queries (reading, creation data structures, creation assertions)
  #********************************************************************************************
  def process_assertions(self, input_name, choose, explode):
  
    # Reading data and saving in a list
    data_out=open_data(input_name)

    # Drops the annotation N-triples that are superfluous to the creation of the tree
    data_out = erase_ann(data_out)

    # Orders the triples putting the anonymous nodes in ascending order
    self.data_ord = order(data_out[0])

    self.elencoassertions = divide_assertions(self.data_ord)

    tmp = []
   
    for el in self.elencoassertions:

      self.data_ord = order(el)

      self.create_tree(0)
            
      tree1 = uri2name(self.tree)
      tree1 = tree1[0]
      if choose == 'assertions':
        # Creation assertions
        class_assertions = AssertionsClass()
        class_assertions.create_assertions(tree1, explode)
        line_tmp = class_assertions.data
        del class_assertions

      elif choose == 'que':
        # Creation queries
        class_que = QueriesClass()
        class_que.create_queries(tree1, explode)
        line_tmp = class_que.data
        del class_que

      tmp.append(line_tmp)

    self.data = tmp

  #********************************************************************************************
  # Creation tree with data to analyze
  #********************************************************************************************
  def create_tree(self, num):

    dat = self.data_ord[num]

    #***************************************************************
    # Variable
    if typeelement(dat[0]) == "an" and riconosci_op(dat[1]) == "var":
      self.tree = ["var",dat[2][1:len(dat[2])-1]]
      return(1)

    #***************************************************************
    # Comparison predicates
    elif riconosci_op(dat[1]) == "mathop" and riconosci_op(dat[2]) in PRED_CONFR:

      i = 0
      listt=['','']
      while i<len(self.data_ord):
        if self.data_ord[i][0] == dat[0] and self.data_ord[i] != dat:
          pip = self.data_ord[i][1]
          if pip[len(pip)-1]=='1':
            listt[0] = i
          else:
            listt[1] = i
        i = i+1

      
      primo = self.data_ord[listt[0]]
      secondo = self.data_ord[listt[1]]

      
      if typeelement(primo[2]) == 'an': # If it is an anonymous node, recursively compute the tree
        i = 0
        trovato = -1
        while i<len(self.data_ord):
          if self.data_ord[i][0] == primo[2]:
            trovato = i
            break
          i = i+1 

        datoprimo = self.data_ord[trovato]
        # If it is a variable
        if typeelement(datoprimo[0]) == "an" and riconosci_op(datoprimo[1]) == "var":
          primotmp = ["var",datoprimo[2][1:len(datoprimo[2])-1]]
        else:
          # Math computation performed recursively
          subtree = TreeClass()
          subtree.data_ord = self.data_ord
          subtree.create_tree(listt[0])
          primotmp = subtree.tree
          del subtree

      else: # If there is not an anonymous node it is a number, and so it can be given in output ...
        primotmp = primo[2]
      
      # Second predicate element
      if typeelement(secondo[2]) == 'an':

        i = 0
        trovato = -1
        while i<len(self.data_ord):
          if self.data_ord[i][0] == secondo[2]:
            trovato = i
            break
          i = i+1 

        datosecondo = self.data_ord[trovato]
        # If it is a variable
        if typeelement(datosecondo[0]) == "an" and riconosci_op(datosecondo[1]) == "var":
          secondotmp = ["var",datosecondo[2][1:len(datosecondo[2])-1]]
        else:
          # Math computation performed recursively
          subtree = TreeClass()
          subtree.data_ord = self.data_ord
          subtree.create_tree(listt[1])
          secondotmp = subtree.tree
          del subtree

      else:
        secondotmp = secondo[2]
     
      self.tree = [dat[2], primotmp, secondotmp]
      
      return(1)
  
    #***************************************************************
    # assertion with simple char strings
    elif typeelement(dat[0]) != "an" and typeelement(dat[2]) != "an":
      self.tree = dat
      return(1)

    #***************************************************************
    # and
    elif riconosci_op(dat[1])=="op" and riconosci_op(dat[2])=="and":   
    
      list_elem = search_subtree(self.data_ord, dat[0])
      num = len(list_elem)
      tree_tmp = []
      u=0
      while u < num:
        # u-th element and
        oper = operator(self.data_ord, list_elem[u])
        if oper[0] == 1:
          subtree = TreeClass()
          subtree.data_ord = self.data_ord
          subtree.create_tree(oper[1])
          tree_tmp_a = subtree.tree
          del subtree
          
        else:
          list_elem1 = search_subtree(self.data_ord, self.data_ord[list_elem[u]][2])
          l=0
          tree_tmp_a = []    
          while l < len(list_elem1):

            subtree = TreeClass()
            subtree.data_ord = self.data_ord       
            subtree.create_tree(list_elem1[l])
            tempor = subtree.tree
            del subtree
            
            if type(tempor) == TYPETUPLE:
              h = 0
              list_t = []
              while h < len(tempor):
                tree_tmp_a.append(tempor[h])
                h = h+1
            else:
              tree_tmp_a.append(tempor)
            l=l+1
            
        tree_tmp.append(tree_tmp_a)
        u=u+1

      self.tree = ['and']+tree_tmp
      return(1)
   
    #***************************************************************
    # or
    elif riconosci_op(dat[1]) == "op" and riconosci_op(dat[2]) == "or":

      list_elem = search_subtree(self.data_ord, dat[0])
      num = len(list_elem)
      tree_tmp=[]
      u = 0
      while u < num:
        # u-th element and
        oper = operator(self.data_ord, list_elem[u])
        if oper[0] == 1:

          subtree = TreeClass()
          subtree.data_ord = self.data_ord          
          subtree.create_tree(oper[1])
          tree_tmp_a = subtree.tree
          del subtree

        else:
          list_elem1 = search_subtree(self.data_ord, self.data_ord[list_elem[u]][2])
          l = 0
          tree_tmp_a = []  
          while l < len(list_elem1):

            subtree = TreeClass()
            subtree.data_ord = self.data_ord            
            subtree.create_tree(list_elem1[l])
            tempor = subtree.tree    
            del subtree

            if type(tempor) == TYPETUPLE:
              h = 0
              list_t = []
              while h < len(tempor):
                tree_tmp_a.append(tempor[h])
                h = h+1
            else:
              tree_tmp_a.append(tempor)
            l = l+1
        tree_tmp.append(tree_tmp_a)
        u = u+1
        
      self.tree = ['or']+tree_tmp
      return(1)

    #***************************************************************
    # not
    elif riconosci_op(dat[1]) == "op" and riconosci_op(dat[2]) == "not":
      list_elem = search_subtree(self.data_ord, dat[0])
      oper = operator(self.data_ord, list_elem[0])
      if oper[0] == 1:
        
        subtree = TreeClass()
        subtree.data_ord = self.data_ord        
        subtree.create_tree(oper[1])
        tree_tmp = subtree.tree
        del subtree
                
      else:
        list_elem1 = search_subtree(self.data_ord, self.data_ord[list_elem[0]][2])
        l = 0
        tree_tmp = []
        while l < len(list_elem1):

          subtree = TreeClass()
          subtree.data_ord = self.data_ord          
          subtree.create_tree(list_elem1[l])
          tempor = subtree.tree
          del subtree

          if type(tempor) == TYPETUPLE:
            u = 0
            list_t = []
            while u < len(tempor):
              tree_tmp.append(tempor[u])
              u = u+1
          else:
            tree_tmp.append(tempor)          
          l = l+1
      self.tree = ['not',tree_tmp]   
      return(1)

    #***************************************************************
    # implies
    elif riconosci_op(dat[1]) == "op" and riconosci_op(dat[2]) == "implies":
      
      list_elem = search_subtree(self.data_ord, dat[0])

      # first element "implies"
      # @@@ here it is... check tree_tmp_a
      oper = operator(self.data_ord, list_elem[0])
      if oper[0] == 1:

        subtree = TreeClass()
        subtree.data_ord = self.data_ord        
        subtree.create_tree(oper[1])
        tree_tmp_a = subtree.tree
        del subtree
      else:
        list_elem1 = search_subtree(self.data_ord, self.data_ord[list_elem[0]][2])
        l = 0
        tree_tmp_a = []
        while l < len(list_elem1):

          subtree = TreeClass()
          subtree.data_ord = self.data_ord          
          subtree.create_tree(list_elem1[l])
          tempor = subtree.tree
          del subtree

          if type(tempor) == TYPETUPLE:
            u = 0
            list_t = []
            while u < len(tempor):
              tree_tmp_a.append(tempor[u])
              u = u+1
          else:
            tree_tmp_a.append(tempor)
          l = l+1
  
      # second element "implies"
      oper = operator(self.data_ord, list_elem[1])
      if oper[0] == 1:

        subtree = TreeClass()
        subtree.data_ord = self.data_ord        
        subtree.create_tree(oper[1])
        tree_tmp_b = subtree.tree
        del subtree

      else:
        list_elem2 = search_subtree(self.data_ord, self.data_ord[list_elem[1]][2])
        l = 0
        tree_tmp_b = []
        while l < len(list_elem2):
  
          subtree = TreeClass()
          subtree.data_ord = self.data_ord          
          subtree.create_tree(list_elem2[l])
          tempor = subtree.tree
          del subtree

          if type(tempor) == TYPETUPLE:
            u = 0
            list_t = []
            while u < len(tempor):
              tree_tmp_b.append(tempor[u])
              u = u+1
          else:
            tree_tmp_b.append(tempor)
          l = l+1
  
      self.tree = ['implies', tree_tmp_b, tree_tmp_a]
      return(1)

    #***************************************************************
    # sub, pre, obj in the case of a statement
    elif riconosci_op(dat[1]) == "sub" or riconosci_op(dat[1]) == "pre" or riconosci_op(dat[1]) == "obj":
      if typeelement(dat[2]) != "an":
        self.tree = dat[2]
      else:
        list_elem = search_subtree(self.data_ord, dat[2])

        subtree = TreeClass()
        subtree.data_ord = self.data_ord      
        subtree.create_tree(list_elem[0])
        temp = subtree.tree    
        del subtree
    
        self.tree = temp
        return(1)

    #***************************************************************
    # Recognizes the variables
    elif variasogg(self.data_ord, dat)[0] == 1:

      # Variable in the subject and object
      if variaogg(self.data_ord, dat)[0] == 1:
        string1 = variasogg(self.data_ord, dat)[1]
        string2 = variaogg(self.data_ord, dat)[1]
        self.tree = [["var", string1[1:len(string1)-1]], dat[1], ["var", string2[1:len(string2)-1]]]
        return(1)

      elif typeelement(dat[2]) == 'an':
        i = 0
        for el in self.data_ord:
          if el[0] == dat[2] and riconosci_op(el[1]) in ("type", "mathop"):
            tipo = riconosci_op(el[1])
            break
          else:
            i = i + 1
            
        # Container in object
        if tipo == "type":
          string1 = variasogg(self.data_ord, dat)[1]
          
          subtree = TreeClass()
          subtree.data_ord = self.data_ord      
          subtree.create_tree(i)
          temp = subtree.tree    
          del subtree

          self.tree = [["var", string1[1:len(string1)-1]], dat[1], temp[0], temp[1]]
          return(1)

        # Math op in the object
        elif tipo == "mathop":
          string1 = variasogg(self.data_ord, dat)[1]

          subtree = TreeClass()
          subtree.data_ord = self.data_ord      
          subtree.create_tree(i)
          temp = subtree.tree    
          del subtree

          self.tree = [["var", string1[1:len(string1)-1]], dat[1], temp[0], temp[1]]
          return(1)

      # String in the object
      else:        
        string1 = variasogg(self.data_ord, dat)[1]
        self.tree = [["var", string1[1:len(string1)-1]], dat[1], dat[2]]
        return(1)

    elif variaogg(self.data_ord, dat)[0] == 1:


      if typeelement(dat[0]) != 'an':
        
        string1 = variaogg(self.data_ord, dat)[1]
        self.tree = [dat[0], dat[1], ["var", string1[1:len(string1)-1]]]
        return(1)
        
      else:

        i = 0
        for el in self.data_ord:
          if el[0] == dat[0] and riconosci_op(el[1]) in ("type", "mathop"):
            tipo = riconosci_op(el[1])
            break
          else:
            i = i + 1
        
        # Container in the subject
        if tipo == "type":

          subtree = TreeClass()
          subtree.data_ord = self.data_ord      
          subtree.create_tree(i)
          temp = subtree.tree    
          del subtree
          
          string1 = variaogg(self.data_ord, dat)[1]
          self.tree = [temp[0], temp[1], dat[1], ["var", string1[1:len(string1)-1]]]
          return(1)

        # Math op in the object
        elif tipo == "mathop":

          subtree = TreeClass()
          subtree.data_ord = self.data_ord      
          subtree.create_tree(i)
          temp = subtree.tree    
          del subtree

          string1 = variaogg(self.data_ord, dat)[1]
          self.tree = [temp[0], temp[1], dat[1], ["var", string1[1:len(string1)-1]]]
          return(1)

        
    #***************************************************************
    # Math ops in simple assertions
    elif operatore_mat(dat, self.data_ord)[0] == 1:
      out = calcola_mat(dat, self.data_ord)
      self.tree = out[0]
      return(out[1])
    

    #***************************************************************
    # Math ops within an assertion (in the case of variables or containers)
    elif riconosci_op(dat[1]) == "mathop" and riconosci_op(dat[2]) in ("add", "divide", "sub", "times"):
      for el in self.data_ord:
        if el[2] == dat[0]:
          break
      out = calcola_mat(el, self.data_ord)
      self.tree = out[0]
      return(out[1])

    
    #***************************************************************
    # bag, alt or seq in the subject or variable
    elif typeelement(dat[0]) == "an" and riconosci_op(dat[2])!= 'sta':

      dat1 = self.data_ord[num+1]
      varia = variable(dat1[2],self.data_ord)
      conte = cont_verify(self.data_ord,num,0)       # conte = 0 false, 1 bag in statement, 2 normal bag

      #################################################
      l = conte[2]+1
      elementi = find_el(self.data_ord, dat[0])

      list_elem = []
      
      for elem in elementi:
        if typeelement(elem[2]) == "an":
          p = 0
          while p < len(self.data_ord):
            if self.data_ord[p][0] == elem[2] and riconosci_op(self.data_ord[p][1]) == "var":
              list_elem.append(["var", self.data_ord[p][2][1:len(self.data_ord[p][2])-1]])
            p=p+1
        else:
          list_elem.append(elem[2])

      if typeelement(dat[2]) == "an":    # Container in the subject and in the object

        conte1 = cont_verify(self.data_ord, num,2)       # conte = 0 false, 1 bag in statement, 2 normal bag

        l = conte1[2]+1
        elem1 = self.data_ord[l] 
        list_elem1 = []
        while elem1[0] == dat[2]:
          if typeelement(elem1[2]) == "an":
            p = 0
            while p < len(self.data_ord): 
              if self.data_ord[p][0] == elem1[2] and riconosci_op(self.data_ord[p][1]) == "var":
                list_elem1.append(["var", self.data_ord[p][2][1:len(self.data_ord[p][2])-1]])
              p = p+1
          else:
            list_elem1.append(elem1[2])
          l = l+1
          if l == len(self.data_ord):
            break
          elem1 = self.data_ord[l]

        self.tree = [conte[1], list_elem, dat[1], conte1[1], list_elem1]
        return(1)

      if conte[0] == 1:
        self.tree = (conte[1], list_elem)
        return(1)
      elif conte[0] == 2:
        self.tree = [conte[1], list_elem, dat[1], dat[2]]
        return(1)
      elif varia[0] == 1:
        self.tree = varia[1]
        return(1)
      else:
        print("Error") 
        self.tree = -1
        return(1)

    
    #***************************************************************
    # bag, alt or seq in object
    elif typeelement(dat[2]) == "an":

      dat1 = self.data_ord[num+1]
      varia = variable(dat1[2], self.data_ord)
      conte = cont_verify(self.data_ord, num,2)       # conte = 0 false, 1 bag in statement, 2 normal bag
    
      l = conte[2]+1
      elem = self.data_ord[l]
      list_elem = []
      while elem[0] == dat[2]:
        if typeelement(elem[2]) == "an":
          p = 0
          while p < len(self.data_ord):
            if self.data_ord[p][0] == elem[2] and riconosci_op(self.data_ord[p][1]) == "var":
              list_elem.append(["var", self.data_ord[p][2][1:len(self.data_ord[p][2])-1]])
            p = p+1
        else:
          list_elem.append(elem[2])
        l = l+1
        if l == len(self.data_ord):
          break
        elem = self.data_ord[l]
      
      if conte[0] == 1:
        self.tree = (conte[1], list_elem)
      elif conte[0] == 2:
        self.tree = [dat[0], dat[1], conte[1], list_elem]
      elif varia[0] == 1:
        self.tree = varia[1]
      else:
        print("Error") 
        self.tree =-1
      
    else:
      self.tree = []



#********************************************************************************************
# Creates tree starting with a math op
#********************************************************************************************
def calcola_mat(dat, data_ord):

  a = operatore_mat(dat, data_ord)
  o = 0 
  tmp = []
  while o < len(data_ord):
    string = data_ord[o][1]

    if data_ord[o][0] == dat[2] and string[0:42] == "http://www.w3.org/1999/02/22-rdf-syntax-ns":
      dato = data_ord[o]
      if typeelement(dato[2]) == "an":
        varia = variable(dato[2], data_ord)
        
        if varia[0] == 1:
          tmp.append(varia[1])
        else:

          subtree = TreeClass()
          subtree.data_ord = data_ord              
          subtree.create_tree(o)
          tmp.append(subtree.tree)
          del subtree
            
      else:
        tmp.append(data_ord[o][2])

    o = o+1

  # Recursive computation
  if dat[1][0:42] == "http://www.w3.org/1999/02/22-rdf-syntax-ns":
    return([(a[1], tmp), 1])

  # Computation on an object with as subject a variable or container
  elif typeelement(dat[0]) == "an" and not(riconoscila(dat[1])):
    return([(a[1], tmp), 1])
  
  else:

    if typeelement(dat[0]) == "an":

      dat1 = data_ord[num+1]
      varia = variable(dat1[2], data_ord)
      conte = cont_verify(data_ord, num, 0)       # conte = 0 false, 1 bag in statement, 2 normal bag

      l = conte[2]+1
      elem = data_ord[l]
      list_elem = []
      while elem[0] == dat[0]:
        if typeelement(elem[2]) == "an":
          p = 0
          while p < len(data_ord):
            if data_ord[p][0] == elem[2] and riconosci_op(data_ord[p][1]) == "var":
             list_elem.append(data_ord[p][2])
            p = p+1
        else:
          list_elem.append(elem[2])
        l = l+1
        if l == len(data_ord):
          break
        elem = data_ord[l]
      return([conte[1], list_elem, dat[1], a[1], tmp], 1)
 
    else:
      return((dat[0], dat[1], a[1], tmp), 1)

     
#********************************************************************************************
# Finds the first element in a bag
#********************************************************************************************
def find_el(data, dat):
  tmp = []
  for el in data:
    if el[0] == dat and riconosci_op(el[1])[0:2] == 'op':
      tmp.append(el)
  return(tmp)
    

#********************************************************************************************
# Function that recognizes the operator (and, or, etc...)
#********************************************************************************************
def riconosci_op(stringa):
  if stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#type":
    return("type")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt":
    return("alt")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag":
    return("bag")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq":
    return("seq")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement":
    return("sta")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#subject":
    return("sub")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate":
    return("pre")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#object":
    return("obj")
  elif stringa=="http://www.w3.org/RDF/Metalog#operator":
    return("op")
  elif stringa=="http://www.w3.org/RDF/Metalog#name":
    return("var")
  elif stringa=="http://www.w3.org/RDF/Metalog#And":
    return("and")
  elif stringa=="http://www.w3.org/RDF/Metalog#Or":
    return("or")
  elif stringa=="http://www.w3.org/RDF/Metalog#Implies":
    return("implies")
  elif stringa=="http://www.w3.org/RDF/Metalog/not/NAF#Not":
    return("not")
  elif stringa[0:44]=="http://www.w3.org/1999/02/22-rdf-syntax-ns#_":
    return "op"+stringa[len(stringa)-1]
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#operator":
    return("mathop")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#add":
    return("add")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#divide":
    return("divide")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#sub":
    return("sub")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#times":
    return("times")  
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#eq":
    return("eq")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#neq":
    return("neq")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#great":
    return("great")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#geq":
    return("geq")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#less":
    return("less")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#leq":
    return("leq")
  elif stringa[0]=='"' and stringa[len(stringa)-1]=='"':
    return("literal")
  else:
    return(stringa)


#********************************************************************************************
# Function that analyzes the data: true assertion
#********************************************************************************************
def assert_true(data_an,i,dat):
  data_temp=data_an[1:i]
  dec=1
  ogg=dat[4]
  stringa="'"+dat[3]+"'('"+dat[2]+"','"+ogg+"')"
  return(data_temp,dec,stringa)


#********************************************************************************************
# Procedure that opens a text file and saves therein the assertions with SWI-Prolog syntax.
# Input:  name  = name of the file where to save the assertions translated in Prolog
#         data  = list of the data to analyze
#         dim   = number of triples
# Output: n     = number of found assertions (-1 in case of error)
#********************************************************************************************
def save_data_prolog(name,data,dim):

  f=open('./dat/'+name,'w')
#  initialize_connector(f)       # Initializes the logical connectors, math ops, containers
  data_out=analyze_assertion(data,dim)		# Analyzes the data and saves them on the file
  main_pro(f)
  f.close()

  return(1)
  

#********************************************************************************************
# Finds the element to analyze: returns list of elements associated to the node
#********************************************************************************************
def search_subtree(data_ord, an):
  list_temp=[]
  list_sta=[[],[],[]]
  i=0
  stat=0
  while i<len(data_ord):
    dat=data_ord[i]
    if riconosci_op(dat[0])==an: 
      tmp=riconosci_op(dat[1])
      if tmp[0:2]=="op" and len(tmp)>2:
        list_temp.append([int(tmp[2:len(tmp)]),i])
      elif tmp=="sub" or tmp=="pre" or tmp=="obj":
        stat=1
        if tmp=="sub":
          list_sta[0]=i
        if tmp=="pre":
          list_sta[1]=i
        if tmp=="obj":
          list_sta[2]=i
      elif tmp=="var":
        return([i])
      i=i+1
    else:
      i=i+1

  if stat==1:  # if a statement
    return(list_sta)
  else:   # if not a statement
    l=0
    list_def=[]
    while l<len(list_temp):
      list_def.append([])
      l=l+1

    l=0
    while l<len(list_temp):
      list_def[list_temp[l][0]-1]=list_temp[l][1]
      l=l+1
  
    return(list_def)


#********************************************************************************************
# Verify if, starting from an anonymous node, there is an operator or an assertion
#********************************************************************************************
def operator(data_ord,n):
  k=0
  while k<len(data_ord):
    if data_ord[k][0]==data_ord[n][2] and riconosci_op(data_ord[k][1])=="op":
      return(1,k)
    elif data_ord[k][0]==data_ord[n][2] and riconosci_op(data_ord[k][1])=="mathop" and riconosci_op(data_ord[k][2]) in PRED_CONFR:
      return(1,k)
    k=k+1
  return(0,0)


#********************************************************************************************
# Verify if there is a variable
#********************************************************************************************
def variable(an,data_ord):
  if typeelement(an)=="an":
    l=0
    while l<len(data_ord):
      if riconosci_op(data_ord[l][1])=="var" and data_ord[l][0]==an:
        return(1,data_ord[l][2])
      l=l+1
    return(0,0)
  else:
    return(0,0)

#********************************************************************************************
# Verify if there is a variable in the subject
#********************************************************************************************
def variasogg(data_ord,dat):
  if typeelement(dat[0])=="an" or typeelement(dat[2])=="an":
    l=0
    while l<len(data_ord):
      if data_ord[l][0]==dat[0] and riconosci_op(data_ord[l][1])=="var":
        return(1,data_ord[l][2])
      l=l+1
    return(0,0)

#********************************************************************************************
# Verify if there is a variable in the object
#********************************************************************************************
def variaogg(data_ord,dat):
  if typeelement(dat[0])=="an" or typeelement(dat[2])=="an":
    l=0
    while l<len(data_ord):
      if data_ord[l][0]==dat[2] and riconosci_op(data_ord[l][1])=="var":
        return(1,data_ord[l][2])
      l=l+1
    return(0,0)

        
#********************************************************************************************
# conte = 0 false, 1 bag in statement, 2 normal bag
#********************************************************************************************
def cont_verify(data_ord,num,k):

  an=data_ord[num][k]
  l=0
  ok=-1
  tarocco=0
  while l<len(data_ord):
    tmp=riconosci_op(data_ord[l][2])
    if data_ord[l][0]==an and riconosci_op(data_ord[l][1])=="type" and (tmp in ("bag","alt","seq")):
      ok=l
    string=data_ord[l][1]
    if string[0:42]!="http://www.w3.org/1999/02/22-rdf-syntax-ns" and data_ord[l][2]==an:
      tarocco=1
    elif string[0:42]!="http://www.w3.org/1999/02/22-rdf-syntax-ns" and data_ord[l][0]==an:
      tarocco=1

    l=l+1
  if ok==-1:
    return(0,0)
  elif tarocco==1:
    return(2,riconosci_op(data_ord[ok][2]),ok)
  else:
    return(1,riconosci_op(data_ord[ok][2]),ok)
  return(0,0)


#********************************************************************************************
# conte = 0 false, 1 math op
#********************************************************************************************
def operatore_mat(dat, data_ord):
  if typeelement(dat[2])=="an":
    an = dat[2]
    l=0
    while l<len(data_ord):
      if data_ord[l][0]==an and riconosci_op(data_ord[l][1])=="mathop":
        return(1, data_ord[l][2])
      l=l+1
  return(0,0)


#********************************************************************************************
# Transform a tree containing non alphanumeric chars into a tree with only alphanumeric chars
#********************************************************************************************
def uri2name(tree):
  if len(tree) == 0:
    return([])
  elif type(tree) == TYPESTRING:
    tree_new=norm_str(tree)
    return([tree_new])
  else:
    i=0
    tree_1=[]
    while i<len(tree):
      tree_2 = uri2name(tree[i])
      i=i+1
      tree_1 = tree_1 + tree_2
    return([tree_1])


#********************************************************************************************
# Procedure that taking a string, returns the same string in upper-case.
#********************************************************************************************
def minusc(stringa):
  out=''
  for car in stringa:
    if car == 'A':
      out = out + 'a'
    elif car == 'B':
      out = out + 'b'
    elif car == 'C':
      out = out + 'c'
    elif car == 'D':
      out = out + 'd'
    elif car == 'E':
      out = out + 'e'
    elif car == 'F':
      out = out + 'f'
    elif car == 'G':
      out = out + 'g'
    elif car == 'H':
      out = out + 'h'
    elif car == 'I':
      out = out + 'i'
    elif car == 'J':
      out = out + 'j'
    elif car == 'K':
      out = out + 'k'
    elif car == 'L':
      out = out + 'l'
    elif car == 'M':
      out = out + 'm'
    elif car == 'N':
      out = out + 'n'
    elif car == 'O':
      out = out + 'o'
    elif car == 'P':
      out = out + 'p'
    elif car == 'Q':
      out = out + 'q'
    elif car == 'R':
      out = out + 'r'
    elif car == 'S':
      out = out + 's'
    elif car == 'T':
      out = out + 't'
    elif car == 'U':
      out = out + 'u'
    elif car == 'V':
      out = out + 'v'
    elif car == 'W':
      out = out + 'w'
    elif car == 'X':
      out = out + 'x'
    elif car == 'Y':
      out = out + 'y'
    elif car == 'Z':
      out = out + 'z'
    else:
      out = out + car    
  return(out)


#********************************************************************************************
# Verify that a string is composed by only upper case chars (and so, is a variable).
#********************************************************************************************
def ismaiusc(stringa):
  mai1 = 1
  for character in stringa:
    if not(character in MAIUSCOLE):
      mai1 = 0
      break
  mai2 = 1
  if stringa[0] == '"' and stringa[len(stringa)-1] == '"':
    stringa1 = stringa[1:len(stringa)-1]
    for character in stringa1:
      if not(character in MAIUSCOLE):
        mai2 = 0
        break
  else:
    mai2 = 0
  return(mai1+mai2)


#********************************************************************************************
# Verify that a string denotes a number
#********************************************************************************************
def isnumber(stringa):
  if stringa[0] == '"' and stringa[len(stringa)-1] == '"':
    stringa1 = stringa[1:len(stringa)-1]
    for character in stringa1:
      if not(character in NUMERI):
        return(0)
    return(1)
  else:
    return(0)
  

#********************************************************************************************
# Tranforms a string containing non alphanumeric chars, into one with just alphanumeric chars
#********************************************************************************************
def norm_str(tree):

  if ismaiusc(tree):
    return(tree)
  elif len(tree) > 30:    
    if tree[0:30]=="http://www.w3.org/RDF/Metalog/":
      return(tree)
  elif isnumber(tree):
    return(tree)
    
  temp1=""
  i=0
  while i<len(tree):
    tt = tree[i]
    if not(tt in MINUSCOLE) and not(tt in NUMERI) :
      plus = str(ord(tree[i]))
      if len(plus) == 1:
        plus = '00' + plus 
      elif len(plus) == 2:
        plus = '0' + plus 
      temp1 = temp1 + 'e' + plus
    else:
      temp1 = temp1 + tree[i]          
    i=i+1
    
  return(temp1)



#********************************************************************************************
# Takes as input the set of triples in a file, and returns the set of the single assertions/queries
#********************************************************************************************
def divide_assertions(table):

  lista_rest = table
  tmp = []
  while lista_rest != []:

    [lista, lista_rest] = find_anoni(lista_rest[0], lista_rest)          # Returns the lst of the relative indexes in the table that
                                                                        # address rows that are part of the asserion
    tmp.append(lista)
  
  return(tmp)


#********************************************************************************************
# Trova lista relativa al nodo anonimo di posizione 1
#********************************************************************************************
def find_anoni(element, rest):
  num1 = num_an(element[0])
  num2 = num_an(element[2])
  if num1 == '-1' and num2 == '-1':
    return([[element],rest[1:len(rest)]])
  else:
    [list1, resto] = find_anonymous(rest)
    return(list1, resto)


#********************************************************************************************
# Trova lista relativa al nodo anonimo numero "num"
#********************************************************************************************
def find_anonymous(rest):
  num1 = num_an(rest[0][0])
  num2 = num_an(rest[0][2])

  lista_an = []
  if num1 != '-1':
    lista_an.append(num1)
  if num2 != '-1':
    lista_an.append(num2)

  save_lista = copylist(rest)
  tmp = rest[1:len(rest)]

  lista = [rest[0]]
  cambiato = 1
    
  while cambiato and tmp != []:
    i = 0
    cambiato = 0
    while i < len(tmp):
      num_a = num_an(tmp[i][0])
      num_b = num_an(tmp[i][2])
      if num_a in lista_an and not(tmp[i] in lista):
        if num_b != '-1' and not(num_b in lista_an):
          lista_an.append(num_b)
          cambiato = 1
        lista.append(tmp[i])
      i = i +1
      
  resto = []
  for el in save_lista:
    if not(el in lista):
      resto.append(el)

  return([lista,resto])


#********************************************************************************************
# Ritorna il numero relativo al nodo anonimo
#********************************************************************************************
def num_an(stringa):
  if len(stringa) > 4:
    if stringa[0:4] == '_:an':
      return(stringa[4:len(stringa)])
    else:
      return('-1')    
  else:
    return('-1')


#********************************************************************************************
# Deletes the annotation N-triples that are superfluous for the creation of the tree
#********************************************************************************************
def erase_ann(data_out):
  data = data_out[0]
  num = data_out[1]
  i = 0
  tmp = []
  for el in data:
    if not(el[1] in ('http://www.w3.org/RDF/Metalog#annotation', 'http://www.w3.org/RDF/Metalog#ns')):
      i = i+1
      tmp.append(el)
      
  return(tmp,i)



