# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
# Module to handle the translator both for the graphical interface
# and the command line mode.


# Imports the system modules
import sys
import os


if 'readcode' in dir(): 
    reload(readcode)
else: import readcode
    
if 'parser_01' in dir(): 
    reload(parser_01)
else: import parser_01

if 'file01' in dir(): 
    reload(file01)
else: import file01

if 'triple_01' in dir(): 
    reload(triple_01)
else: import triple_01

if 'rdfxml_a04' in dir(): 
    reload(rdfxml_a04)
else: import rdfxml_a04

if 'cost' in dir():  # imports cost module
    reload(cost)
else: import cost



class TheTranslator:

    def __init__(self):
        self.FF=None
        self.LL=None
        self.TT=None
        self.RR=None
        self.TR=None


    #creates an instance of the error class
    def initError(self,E):
        self.EE=E 



    #handles the creation of the RDF/XML code
    
    def createCodeRdf(self,nameFileIn,type='stat',nameFileOut=None):
        
        self.nameFileIn=nameFileIn
        self.FF=file01.TheFile(self.nameFileIn,nameFileOut) 
        self.LL=readcode.ReadCode(self.FF,self.EE)
        self.LL.stripOff()
        self.TT=parser_01.Parse(self.LL,self.FF,self.EE)
        self.TT.divide() # splits in two lists the queries and the assertions
        if type=='stat':
            self.TT.parseStat() 
        elif type=='query':
            self.TT.parseQuery() 
        else:
            print 'ERROR in createCodeRdf'
        self.TT.createTree()

        self.RR=rdfxml_a04.RdfXml(self.FF, self.EE)
        CodeRDFXML =self.RR.createRDFXML(self.TT.returnListTree())    

        if nameFileOut!=None:
            self.FF.writeToFileOut(CodeRDFXML)

        self.FF.removeTmpFile() #removes the temp files
        return CodeRDFXML 

   


    #handles the creation of the N-triples
    
    def createNTriple(self,nameFileIn,type='stat',nameFileOut=None):

        self.nameFileIn=nameFileIn
        self.FF=file01.TheFile(self.nameFileIn,nameFileOut) 
        self.LL=readcode.ReadCode(self.FF,self.EE)
        self.LL.stripOff()
        self.TT=parser_01.Parse(self.LL,self.FF,self.EE)
        self.TT.divide() # splits into two lists the queries and the assertions
        if type=='stat':
            self.TT.parseStat() 
        elif type=='query':
            self.TT.parseQuery() 
        else:
            print 'ERROR in createNTriple'    
        self.TT.createTree()
        
        self.TR=triple_01.Triple(self.TT,self.FF)  # using N-triples
        nTriple=self.TR.createTriple()

        if nameFileOut!=None:
            self.FF.writeToFileOut(nTriple)
        self.FF.removeTmpFile() #removes the temp files
        return nTriple



       

    #deletes all the created instances
        
    def destroyAll(self):
        self.FF=None
        self.LL=None
        self.TT=None
        self.RR=None
        self.TR=None


    def nameFileIn(self):
        if self.FF!=None:
            return self.FF.retNameFileIn()
        else:
            return -1

    def nameFileOut(self):
        if self.FF!=None:
            return self.FF.retNameFileOut()
        else:
            return -1        

    def nameFileTmp(self):
        if self.FF!=None:
            return self.FF.retNameFileTmp()
        else:
            return -1


    def saveToFileLog(self,string):
        self.FF.writeToFileLog(string)
      

  


