# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
# This module defines the -Parser- class
# that uses the list representing the code
# obtained from the -ReadCode- class
# and gives back the list representing the tree
# that defines the logical structure of the sentences.
# For the construction of the tree we use the -Tree- class
# defined in the tree module.

if 'cost' in dir():  # import cost module
    reload(cost)
else: import cost

if 'tree_e02' in dir():  # import tree module
    reload(tree_e02)
else: import tree_e02


# Class used for the creation of the tree
# representing the logical structure of the sentences.
class Parse:


    # class constructor
    # L = istance of the ReadCode object (readcode module)
    # F = instance of the File object (file module)
    # E = instance of the Error object (error module)

    def __init__(self,L,F,E):
        self.L=L
        self.F=F
        self.E=E
        
        self.listExt=self.L.returnList()  



    # split the assertions and the query 
    # in two separate lists
    def divide(self):
        self.listStat=[]
        self.listQuery=[]
        listTmp=[]
	while len(self.listExt)!=0:
	    elem=self.listExt.pop(0)
	    listTmp.append(elem)
	    if elem[0]=='.':
		self.listStat.extend(listTmp)
		listTmp=[]
	    if elem[0]=='?':
		self.listQuery.extend(listTmp)
		listTmp=[]
    
        if  len(listTmp)!=0:
            self.listStat.extend(listTmp)


    
	    
    # initialize the parser
    # with the query as input
    def parseStat(self):
        self.listIn=self.listStat
        self.lenList=len(self.listIn) -1
        self.T=''        
        self.T=tree_e02.Tree()  
        self.listTree=[]
        self.OK=0  
        self.Query=0

    # initialize the parser
    # with the statements as input
    def parseQuery(self):
        self.listIn=self.listQuery
        self.lenList=len(self.listIn) -1
        self.T=''        
        self.T=tree_e02.Tree()  
        self.listTree=[]
        self.OK=0  
	self.Query=1


    # returns the list representing the tree encoding the sentences
    def returnListTree(self):
        return self.listTree

    
    # returns the i-th element of the list
    # of the code discarding the field indicating
    # the position in the file of such element
    # i= element number
    def elemList(self,i):
        return self.listIn[i][0:2]


    # returns the position in the file
    # of the i-th element
    # i = element number
    def posList(self,i):
        return self.listIn[i][2]


    # check whether (1) or not (0) the i-th element
    # belongs to one of the following categories:
    
    def isHolder(self,i):     # strings, variables and URIs
        return self.listIn[i][0] in cost.HOLDER

    def isQuot(self,i):     # strings
        return self.listIn[i][0] == 'q'

    def isUri(self,i):   
        return self.listIn[i][0] == 'u'

    def isVar(self,i):  
        return self.listIn[i][0] == 'v'

    def isOrder(self,i):
        return self.listIn[i][0] in cost.ORDER

    def isAnd(self,i):
        return self.listIn[i][0] == 'and'

    def isOr(self,i):
        return self.listIn[i][0] == 'or'

    def isImply(self,i):
        return self.listIn[i][0] == 'imply'

    def isNot(self,i):
        return self.listIn[i][0] == 'not'
    
    def isPunct(self,i):   #punctuation
        return self.listIn[i][0] == '.' or  self.listIn[i][0] == '?'  

    def isComma(self,i):   # comma
        return self.listIn[i][0] == ','

    def isOp(self,i):
        return self.listIn[i][0] in ['add','sub','times','divide']
    def isAdd(self,i):
        return self.listIn[i][0] == 'add'
    def isSub(self,i):
        return self.listIn[i][0] == 'sub'
    def isTimes(self,i):
        return self.listIn[i][0] == 'times'    
    def isDivide(self,i):
        return self.listIn[i][0] == 'divide'

    def isPred(self,i):
        return self.listIn[i][0] in ['eq','neq','less','great','leq','geq']
    def isEq(self,i):
        return self.listIn[i][0] == 'eq'
    def isNeq(self,i):
        return self.listIn[i][0] == 'neq'
    def isLess(self,i):
        return self.listIn[i][0] == 'less'
    def isGreat(self,i):
        return self.listIn[i][0] == 'great'
    def isLeq(self,i):
        return self.listIn[i][0] == 'leq'
    def isGeq(self,i):
        return self.listIn[i][0] == 'geq'
    
    # main method used to create the tree that describes the sentences
    # cycles in the three levels 1,2,3
    # (using the respective methods)
    def createTree(self):
        if self.lenList==-1:
	    if self.Query==0:
		strMsg='ERROR: No statement to analyze.'
	    elif self.Query==1:
		strMsg='ERROR: No query to analyze.'
	    else:
		strMsg='ERROR: No code to analyze.'
	 #   self.E.errorToFile(self.F,strMsg,-1)
	    self.E.errorToFile(self.F,strMsg,-1)
           
        lev=1
        i=0
        while (i<=self.lenList):
            if (lev==1):
                self.OK=0  # flag OK
                [lev,i]=self.level1(i)  
            elif (lev==2):
                self.OK=0  # flag OK
                [lev,i]=self.level2(i)
            elif (lev==3):
                self.OK=0  # flag OK
                [lev,i]=self.level3(i)
            elif (lev==0):   # level to exit the cycle
                break

        if self.OK==1:
            self.listTree=self.T.list()
        else:
            strMsg='ERROR: Sentence not correctly ended.' 
            self.E.errorToFile(self.F,strMsg,self.posList(i-1))      
        


    # adds in the appropriate position
    # the i-th word in the tree
    # following the rules defined in level 1
    def level1(self,i):
 
    # I am at the beginning of the list
        if i==0:
            if self.isHolder(i):   #if a holder is found...
                self.T.new_stat()
                self.T.subj(self.elemList(i)) 
                return [2,i+1]  #... goes to level 2
            else:
                strMsg='ERROR: The first element of the list must be a string or a variable.' 
                self.E.errorToFile(self.F,strMsg,self.posList(i)) 

    #I am at the end of the list
        elif i==self.lenList:
            if self.isPunct(i):   #if a dot is found...
                self.OK=1
                return [0,i]  # ... 0 is the lvel to exit from the main cycle
            else:
                strMsg='ERROR: Here I need a dot to end the sentence.' 
                self.E.errorToFile(self.F,strMsg,self.posList(i))  

        elif i==self.lenList-1 and not self.isPunct(i+1):   
                strMsg='ERROR: After this word there must be a dot' 
                self.E.errorToFile(self.F,strMsg,self.posList(i+1))    
    

    # I am in the middle of the list (neither at the beginning, nor at the end)
        else:
            if self.isHolder(i): #I have a holder
                if self.isPunct(i-1):
                    self.T.subj(self.elemList(i))
                    return [2,i+1]
                elif self.isAnd(i-1) or self.isOr(i-1) or self.isImply(i-1):
                    self.T.subj(self.elemList(i))
                    return [2,i+1]
                else:
                    strMsg='ERROR: Before beginning a new statement you must conclude the previous one with a dot.' 
                    self.E.errorToFile(self.F,strMsg,self.posList(i))    
            
            elif self.isPunct(i):  #I find a dot
                if self.isHolder(i+1): #next element is a holder
                    self.OK=1  
                    self.T.new_stat()
                    return [1,i+1]  #remains at level 1
                else: 
                    strMsg='ERROR: After the dot there must be either a variable or a string or a URI.' 
                    self.E.errorToFile(self.F,strMsg,self.posList(i)) 
            
            elif self.isComma(i): #I find a comma and after it there is:
                if self.isOr(i+1):  #an "or", ok
                    self.T.newOrStat()
                    return [1,i+2] 
                elif self.isAnd(i+1):  #an "and", ok
                    self.T.newAndStat()
                    return [1,i+2]
                elif self.isHolder(i+1): #a holder, ok
                    return [1,i+1]
                elif self.isImply(i+1): #an "imply", error
                    strMsg='ERROR: After the comma there cannot be the keywords: "then", "imply", "implies"' 
                    self.E.errorToFile(self.F,strMsg,self.posList(i+1))    
                elif self.isOrder(i+1): #an "order", error
                    strMsg='ERROR: After the comma there cannot be the keyword: "order".' 
                    self.E.errorToFile(self.F,strMsg,self.posList(i+1))    
                elif self.isNot(i+1): #a "not", error
                    strMsg='ERROR: After the comma there cannot be the keyword: "not".' 
                    self.E.errorToFile(self.F,strMsg,self.posList(i+1))    
                else:
                    strMsg='ERROR: After the comma there is something wrong.' 
                    self.E.errorToFile(self.F,strMsg,self.posList(i+1))  

            elif self.isImply(i): #I have an "imply"
                self.T.newImplyStat()
                return [1,i+1]

            elif self.isAnd(i): # I have an "and" and afterwards...
                if self.isHolder(i+1):   #...a holder and afterwards...
                    if self.isHolder(i+2): #...a holder : logical and
                        self.T.newAndStat()
                        return [1,i+1]
                    elif self.isOrder(i+2):  #...an "order": deq container
                        self.T.addSeqObj2(self.elemList(i+1)) 
                        return [1,i+3]
                    elif self.isNot(i+2):  #...a "not": error
                        strMsg='ERROR: The "not" keyword can be put only between predicate and subject.' 
                        self.E.errorToFile(self.F,strMsg,self.posList(i+2)) 
                    else:       #bag in the object
                        self.T.addBagObj(self.elemList(i+1))
                        return [1,i+2]
                else:
                    strMsg='ERROR: After the keyword "and" there must be either a variable or a string or a URI.' 
                    self.E.errorToFile(self.F,strMsg,self.posList(i+1)) 

            elif self.isOr(i): #I have an "or" and afterwards...
                if self.isHolder(i+1): # ...I have a holder and afterwards...
                    if self.isHolder(i+2): #... I have a holder: logical or
                        self.T.newOrStat()
                        return [1,i+1]
                    elif self.isNot(i+2):  #...I have a "not": error
                        strMsg='ERROR: The "not" keyword can be put only between predicate and subject' 
                        self.E.errorToFile(self.F,strMsg,self.posList(i+2)) 
                    elif self.isOrder(i+2):  #...I have an "order": error
                        strMsg='ERROR: "order" cannot follow an "or" as it creates a sequence only after an "and"' 
                        self.E.errorToFile(self.F,strMsg,self.posList(i+2)) 
                    else:   #alt in the object
                        self.T.addAltObj(self.elemList(i+1))
                        return [1,i+2]
                else:
                    strMsg='ERROR: After an "or" there must be either a variable or a string or a URI.' 
                    self.E.errorToFile(self.F,strMsg,self.posList(i+1))

            elif self.isOp(i): # I have a math op
                typeOp=self.listIn[i][0]

                if not (self.isVar(i-1) or self.isQuot(i-1)): #before I have a holder
                    strMsg='ERROR:An math operator must to use only string or a variable'                    
                    self.E.errorToFile(self.F,strMsg,self.posList(i)) 

                elif self.isQuot(i-1) and not (self.listIn[i-1][1].isdigit()): # if quote is a number
                    strMsg='ERROR: a string in math operator must be a number'
                    self.E.errorToFile(self.F,strMsg,self.posList(i)) 

                # If after a comparison there is a math op
                elif ((self.isVar(i+1) or self.isQuot(i+1)) and self.isPred(i-2)):
                    self.T.addPredMath(self.elemList(i+1),typeOp,'prec')
                    return [1, i+2]
                
                elif self.isVar(i+1):   #...I have a variable
                    self.T.addOpObj(self.elemList(i+1),typeOp) # function to implement on the tree (bag type in the object)
                    return [1,i+2]
                elif self.isQuot(i+1) and self.listIn[i+1][1].isdigit(): #string with a number
                    self.T.addOpObj(self.elemList(i+1),typeOp) # function to implement on the tree bag type in the object)
                    return [1,i+2]
               
                else:
                    strMsg='ERROR: After a math op there must be either a variable or a string (with number)"' 
                    self.E.errorToFile(self.F,strMsg,self.posList(i))


            elif self.isPred(i): # if a comparison predicate is found...
                typeOp=self.listIn[i][0]  
                
                if not (self.isVar(i-1) or self.isQuot(i-1)): #before I have a holder
                    strMsg='ERROR:A predicate must to use only string or a variable'                    
                    self.E.errorToFile(self.F,strMsg,self.posList(i))

                elif self.isQuot(i-1) and not (self.listIn[i-1][1].isdigit()): # if quote is a number
                    strMsg='ERROR: a string in predicate must be a number'
                    self.E.errorToFile(self.F,strMsg,self.posList(i)) 
                            
                elif self.isVar(i+1):   #...I have a variable
                    self.T.addPredObj(self.elemList(i+1),typeOp) # function to implement on the tree (bag type on object)
                    return [1,i+2]
                elif self.isQuot(i+1) and self.listIn[i+1][1].isdigit(): #string with number
                    self.T.addPredObj(self.elemList(i+1),typeOp) # function to implement on the tree (bag type on object)
                    return [1,i+2]
        

    # adds in the appropriate position
    # the i-th word in the tree
    # following the rules defined in level 2
    def level2(self,i):

        if i!=self.lenList:
            if self.isQuot(i) or self.isUri(i):  #found the verb
                self.T.pred(self.elemList(i))
                return [3,i+1]

            elif self.isVar(i): #found the variable: error
                strMsg='ERROR: The predicate cannot be a variable.' 
                self.E.errorToFile(self.F,strMsg,self.posList(i)) 

            elif self.isPunct(i) or self.isComma(i): #found punctuation: error
                strMsg='ERROR: Not dot or comma is allowed after the subject.' 
                self.E.errorToFile(self.F,strMsg,self.posList(i)) 

            elif self.isOr(i): # if I find an "or" and afterwards...
                if self.isHolder(i+1): #..I have a holder and afterwards...
                    if self.isVar(i+2) : #variable: error
                        strMsg='ERROR: The predicate cannot be a variable.' 
                        self.E.errorToFile(self.F,strMsg,self.posList(i)) 
                    elif self.isOrder(i+2):   #I find an order: error
                        strMsg='ERROR:"order" cannot follow an "or" as it creates a sequence only after an "and"'
                        self.E.errorToFile(self.F,strMsg,self.posList(i+2)) 
                    elif self.isNot(i+2):  #...I have a not: error
                        strMsg='ERROR: The "not" can only be put between a predicate and an object' 
                        self.E.errorToFile(self.F,strMsg,self.posList(i+2)) 
                    else:  #alt in the subject
                        self.T.addAltSubj(self.elemList(i+1))
                        return [2,i+2]
                else:
                    strMsg='ERROR: After an "or" there must be either a variable or a string or a URI' 
                    self.E.errorToFile(self.F,strMsg,self.posList(i+1)) 
                    
            elif self.isAnd(i): # if I find an "and" and afterwards...
                if self.isHolder(i+1): #..I have a holder and afterwards...
                    if self.isVar(i+2) : #a variable: error
                        strMsg='ERROR: The predicate cannot be a variable.' 
                        self.E.errorToFile(self.F,strMsg,self.posList(i)) 
                    elif self.isOrder(i+2):   #I found an oder: seq in subject
                        self.T.addSeqSubj2(self.elemList(i+1))
                        return[2,i+3]  
                    elif self.isNot(i+2):  #...I have a "not": error
                        strMsg='ERROR: The "not" can be put only between predicate and object' 
                        self.E.errorToFile(self.F,strMsg,self.posList(i+2)) 
                    else:  #bag in subject
                        self.T.addBagSubj(self.elemList(i+1))
                        return [2,i+2] 
                else:
                    strMsg='ERROR: After an "and" there must be either a variable or a string or a URI' 
                    self.E.errorToFile(self.F,strMsg,self.posList(i+1))
                    
            elif self.isPred(i): # If I find a comparison predicate...
                typeOp=self.listIn[i][0]  
                
                if not (self.isVar(i-1) or self.isQuot(i-1)): #before I have a hlder
                    strMsg='ERROR:A predicate must to use only string or a variable'                    
                    self.E.errorToFile(self.F,strMsg,self.posList(i))

                elif self.isQuot(i-1) and not (self.listIn[i-1][1].isdigit()): # if quote is a number
                    strMsg='ERROR: a string in predicate must be a number'
                    self.E.errorToFile(self.F,strMsg,self.posList(i)) 
                            
                elif self.isVar(i+1):   #...I have a variable
                    self.T.addPredObj(self.elemList(i+1),typeOp) # function to implement on tree (bag type on object)
                    return [1,i+2]
                elif self.isQuot(i+1) and self.listIn[i+1][1].isdigit(): #string with number
                    self.T.addPredObj(self.elemList(i+1),typeOp) # function to implement on tree (bag type on object)
                    return [1,i+2]
               
                else:
                    strMsg='ERROR: After a predicate op there must be either a variable or a string (with number)"' 
                    self.E.errorToFile(self.F,strMsg,self.posList(i))
           
            # If after a math op there is a comparison
            # If after a math op in this level there is necessarily a comparison
            elif self.isOp(i):
                typeOp=self.listIn[i][0]  
                self.T.addPredMath(self.elemList(i+1),typeOp,'succ')
                return [1, i+2]
            else:
                print self.listIn[i][0]

        else:
            strMsg='ERROR! Statement finished incorrectly.' 
            self.E.errorToFile(self.F,strMsg,self.posList(i))

    # adds in the appropriate position
    # the i-th word in the tree
    # following the rules defined in level 3
    def level3(self,i):

        if i!=self.lenList:
            if self.isHolder(i): #object
                self.T.obj(self.elemList(i))
                return [1,i+1]
            elif self.isNot(i): #not
                self.T.notStat()
                return [3,i+1]
            else:
                strMsg='ERROR: Either a string or a variable or a URI or a "not" must be present here.' #ERROR HANDLING
                self.E.errorToFile(self.F,strMsg,self.posList(i)) #handle the origin file too
        else:
            strMsg='ERROR: Statement finished incorrectly.' #ERROR HANDLING
            self.E.errorToFile(self.F,strMsg,self.posList(i)) #handle the original file too
        
    
