# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# Module METALOG PROJECT - N-Triple processor ---        #
# Prolog results                                         #
#********************************************************#

import os
import sys
import time

# Import module for interface to the logic system
from interfaceprolog import LogicClass

# Import module of aalysis results from Prolog system
from resultprolog import ResultClass
     
# Import module for the tree creation
from tree import TreeClass

# Import module for the constants definition
from definitions import *

# Import module containing the auxiliary procedures
from procedure import *


#********************************************************#
# Class creating the listing facts/clauses/queries
#********************************************************#
class MetalogHeartClass:

  "Metalog Heart Class"
  
  #********************************************************************************************
  # Initialiaztion of the internal data structures
  #********************************************************************************************
  def __init__(self):
    self.data = []

  #********************************************************************************************
  # Procedure creating assertions and queries starting from the "tree" graph by applying the conversion rules
  #********************************************************************************************
  def runmetalog(self, input_name, query_name, configurations):

    [ANS, SYSPROLOG, EXP_ASSERTIONS, EXP_QUE, MACRO, MLNT, CALCULATE_CONT] = configurations
              
    # Creation of the assertions tree and of the assertions table
    tree_assertions = TreeClass()
    tree_assertions.process_assertions(input_name, 'assertions', EXP_ASSERTIONS)
    assertions = tree_assertions.data
    del tree_assertions

    # Creation of the query tree and of the query table
    tree_que = TreeClass()
    tree_que.process_assertions(query_name, 'que', EXP_QUE)
    queries = tree_que.data
    del tree_que

    i = 0
    num_queries = len(queries)

    tmp = []

    while i < num_queries:
      query = [queries[i]]

      # Save the assertions on file to transfer them to the Prolog system
      # Returns list containing the saved variables
      data_class = LogicClass()
      data_class.save_data(assertions, query, SYSPROLOG, ANS)
      [list_var_a, list_var_q] = data_class.data
      del data_class

      # Analysis of the output files of the inferential system (results of the assertions and query)
      result_class = ResultClass()
      result_class.analyze_results(assertions, query, list_var_a, list_var_q)
      result = result_class.data
      del result_class
      tmp = tmp + [result]
        
      i = i + 1

    self.data = tmp

