% SWI-Prolog program for the Metalog Project.
% One answer case


asserisci(Fin,Fout):-

    at_end_of_stream(Fin)->
    
        fail;
        
        repeat,
        catch(
                read_term(Fin,Goal,
                     [syntex_errors(dec10), variable_names(Vars)]
                ),
                E,
                (write(Fout,'End\nend_of_file\nEnd'),
%%                 write(Fout,E),
                 write(Fout,'\n'),
                 close(Fout),
                 close(Fin),
                 open('temp/ok.tmp',write,Fok),
                 write(Fok,'Prolog process terminated'),
                 close(Fok),
                 halt)
        ),
        catch(
                output_solution(Fout, Goal),
                E,
                (write(Fout,'End\nend_of_file\nEnd'),
%%                 write(Fout,E),
                 write(Fout,'\n'),
%%                 write(Fin),
%%                 write(Fout),
                 close(Fout),
                 close(Fin),
                 open('temp/ok.tmp',write,Fok),
                 write(Fok,'Prolog process terminated'),
                 close(Fok),
%                 sleep(10),                % waits 10 secs to visualize possible warnings or errors
                 halt
        )),
        More = false,
        asserisci(Fin,Fout).
        
output_solution(Fout, Goal) :-
        write(Fout, Goal),
        write(Fout,'\n'),
%        get_solution(Fout, Goal, GotSolution),
        output_result(Fout, Goal).

get_solution(Fout, Goal, true) :-
        Goal.
        
get_solution(Fout, _, false) :-
        write(Fout,'End'),         % This string is printed when the answer to a query os False, and at the
                                     % end of the list of all the answers to a query
        write(Fout,'\n').

output_result(Fout, Goal) :-
 
        Goal -> 
        !,
        write(Fout, 'True\n'),
        write(Fout, Goal),
        write(Fout, '\n'),
        write(Fout, 'End\n');
        write(Fout, 'End\n').


output_result(Fout, false).


write_bindings(Fout,Vars):-
        write(Fout,'['),
        write_each_binding(Fout,Vars),
        write(Fout,']\n').

write_each_binding(Fout,[]):- write(Fout,'').
write_each_binding(Fout,[B]) :- 
        !,
        write_binding(Fout,B).

write_each_binding(Fout,[B|Bs]) :-
        write_binding(Fout,B),
        write(Fout,'\,'),
        write_each_binding(Fout,Bs).

write_binding(Fout,B) :-
        write(Fout,'\''),
        write(Fout,B),
        write(Fout,'\'').

:-
%  open('temp/pipeout.tmp',write,Fout),             % Deletes temp file if already present
%  close(Fout),                                             
  open('temp/pipein.tmp',read,Fin),
  open('temp/pipeout.tmp',write,Fout),
  asserisci(Fin,Fout),
  close(Fin),
  close(Fout).
