# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# Module that interfaces the Metalog Logic Level with the Prolog inferential system
#********************************************************#


# Import libraries
import time

# Import libraries
import os

# Import misc constants
from definitions import *

# Import procedures
from procedure import *


#********************************************************#
# Class that creats the listing of facts/clauses/queries
#********************************************************#
class LogicClass:

  "Class that create Table with fact,, queries "


  #********************************************************************************************
  # Initialization of the internal data structures
  #********************************************************************************************
  def __init__(self):
    self.data = []


  #********************************************************************************************
  # Save assertions on file for transfer to the Prolog system
  #********************************************************************************************
  def save_data(self, table_assertions, table_queries, system, answers):

    if [-1] in table_assertions:
     print("There are invalid assertions")
    elif [-1] in table_queries:
      print("There are invalid queries")
    else:

      # Opening the file for the passage of data to the Prolog system
      pipe_in=open(PIPEIN,'w')

      list_var_assertions = []
      for assertions in table_assertions:
        # Saving assertion to the output files
        var_assertions = save_data_file(assertions, "assertions", pipe_in)
        list_var_assertions = list_var_assertions + var_assertions

      list_var_que = []
      for queries in table_queries:
        # Saving queries to the output files
        var_que = save_data_file(queries, "que", pipe_in)
        list_var_que = list_var_que + var_que
      # Closing output files
      pipe_in.close()


      # Delete (if present) the temp files indicating the termination of the processng
      ce=os.path.isfile(OK)
      if ce:
        os.remove(OK)

      if system == '1':
#        print("Wait please, data elaboration with SWI-Prolog still ongoing ...\n\n")

        DIRWORK=os.getcwd()
        os.chdir(DIR_LIB)

	# Launching SWI-Prolog
        if answers == '1':


          # Launch SWI-Prolog
          if OP_SYSTEM == 'win':
            aa = os.startfile(PL_FILE_SINGLE)
          else:
            aa = os.system("pl -f "+PL_FILE_SINGLE+" -t halt")
          while 1:
            time.sleep(1)
            if os.path.isfile(OK):
              break
        elif answers == '2':

          # Launch SWI-Prolog
          if OP_SYSTEM == 'win':
            aa = os.startfile(PL_FILE_MULTI)
          else:
            aa = os.system("pl -f "+PL_FILE_MULTI+" -t halt")

          while 1:
            time.sleep(1)
            if os.path.isfile(OK):
              break
        else:
          self.data = -1

        os.chdir(DIRWORK)

      elif system == '2':
        print("Not supported in this version\n")
        self.data = -1
##        print("Wait please, data elaboration with Pylog system still ongoing ...\n\n")
#        # Import interface module to the Pylog system
#        from metapylog import metapy
#        out = metapy()
#        print out
#        if out!=1:
#          self.data = -1

      else:
        self.data = -1

      # Return the lists of the variables
      self.data = [list_var_assertions, list_var_que]


#********************************************************************************************
# Save assertions to file for transferring to the Prolog system
#********************************************************************************************
def save_data_file(list, string, pipe_in):

  head=""
  tail=""
  if string=="assertions":
    head="assert("
    tail=")"

  i=0
  list_var=[]
  while i<len(list[0]):
    out = check_var(list[0][i])
    p = 0
    while p < len(out):
      el = out[p]
      if el[0]!="":
        list_var = list_var + [[el[0], i, p, 'sub']]
      if el[1]!="":
        list_var = list_var + [[el[1], i, p, 'obj']]
      p = p + 1
    num=pipe_in.write(head+list[0][i]+tail+".\n")
    i=i+1

  return(list_var)



#********************************************************************************************
# Check the presence of variables in a list
#********************************************************************************************
def check_var_list(lista):
  list_tmp = lista[1:len(lista)-1]
  list_var = []
  while list_tmp != "":
    next = find_char_norm(list_tmp, ',')
    if next == -1:
      next = len(list_tmp)
      element = list_tmp
    else:
      element = list_tmp[0:next]
    if element[0]==" ":
      element = element[1:len(element)]
    if element[len(element)-1]==" ":
      element = element[0:len(element)-1]
    sub_tmp = 1
    for character in element:
      if not(character in MAIUSCOLE):
        sub_tmp=-1
        break
    if sub_tmp == 1:
      list_var.append(element)
    else:
      list_var.append("")
    list_tmp = list_tmp[next+1:len(list_tmp)]


  return(list_var)



#********************************************************************************************
# Check the presence of variables before saving the data
#********************************************************************************************
def check_var(stringa):

  n1 = find_char_norm(stringa, '(')
  if stringa[n1+1] == "[":
    n4 = find_char_norm(stringa, ']')
    lista = stringa[n1+1:n4+1]
    list_sub_var = check_var_list(lista)
    resto = stringa[n4+2:len(stringa)]
  else:
    n2 = find_char_norm(stringa, ',')
    sub = stringa[n1+1:n2]
    sub_tmp = 1
    for character in sub:
      if not(character in MAIUSCOLE):
        sub_tmp=-1
        break
    if sub_tmp == 1:
      list_sub_var = [sub]
    else:
      list_sub_var = []
    resto = stringa[n2+1:len(stringa)]

  while resto[0] == " ":
    resto = resto[1:len(resto)]
        
  if resto[0] == "[":
    n4 = find_char_norm(resto, ']')
    lista = resto[0:n4+1]
    list_obj_var = check_var_list(lista)
    n2 = find_char_norm(resto, ')')
    rimanente = resto[n2+1:len(resto)]
  else:
    n2 = find_char_norm(resto, ')')
    obj = resto[0:n2]
    obj_tmp = 1
    rimanente = resto[n2+1:len(resto)]
    for character in obj:
      if not(character in MAIUSCOLE):
        obj_tmp=-1
        break
    if obj_tmp == 1:
      list_obj_var = [obj]
    else:
      list_obj_var = []

  if len(rimanente)>2:
    if rimanente[0] in (',', ';'):
      tmp1 = check_var(rimanente[1:len(rimanente)])
      tmp = [[list_sub_var, list_obj_var]] + tmp1
    else:
      tmp = [[list_sub_var, list_obj_var]]  
  else:    
    tmp = [[list_sub_var, list_obj_var]]
  
  return(tmp)
