# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
# This module implements the class -File-
# used to handle the files used in the program

import sys
import os

import urllib # used to get files on the WWW
import urlparse #analyzes the URLs

# Class that handles the operations on files used in the program:
# input, output (rdf and N-triples) and temp files
class TheFile:

    # class constructor
    # if the input file is provided with the complete path
    # changes the work directory into the current one
    # creates the output files (triple and rdf) and temp 
    # nameFileIn= name of the input file
    def __init__(self,nameFileIn,nameFileOut=None): # modified on 16/4/02 built

        splitPath=nameFileIn.split('/')
        self.onlyNameIn=splitPath[-1]  
        dirWork=os.sep.join(splitPath[:-1]) #extracts the work directory
        if self.onlyNameIn!=nameFileIn: 
            os.chdir(dirWork)  #goes to the work directory

        self.nameFileIn=self.onlyNameIn
        self.nameFileOut=nameFileOut
        self.nameFileTmp=self.nameFileIn.split('.')[0]+'.tmp'
        self.nameFileNet=self.nameFileIn.split('.')[0]+'.net'

        try:
            self.fileIn=open(self.nameFileIn,'r')
        except IOError:
            print 'ERROR: Read to file %s ' %self.nameFileIn
            sys.exit()

        if self.nameFileOut!=None:
            try:
                self.fileOut=open(self.nameFileOut,'w') #creates the Out file
            except IOError:
                print 'ERROR: Write to file %s ' %self.nameFileOut
                sys.exit()
        else:
            self.fileOut=None

        try:
            self.fileTmp=open(self.nameFileTmp,'w') #creates the Tmp file
            self.fileNet=open(self.nameFileNet,'w') #creates the Net file
        except IOError:
            print 'ERROR: Cannot open temp files'
            sys.exit()

 
        self.stringIn=self.readToFileIn()
        self.stringTmp=self.readToFileTmp() 


    
 
    # gives back the input file name
    def retNameFileIn(self):
        return self.onlyNameIn

    # gives back the out file name
    def retNameFileOut(self):
        return self.nameFileOut

    # gives back the temp file name
    def retNameFileTmp(self):
        return self.nameFileTmp

    
    # opens the input file with modality "mode"
    # and gives back the id
    # if a non-allowed modality is chosen then returns -1
    # mode = file modality
    def idFileIn(self,mode='r'):
        mode=mode.lower()
        if mode=='r' or mode=='w':
            if (not self.fileIn.closed) and (self.fileIn.mode== mode):
                self.fileIn.seek(0)
                return self.fileIn
            else:
                self.fileIn=open(self.nameFileIn,mode)
                self.fileIn.seek(0)
                return self.fileIn
        else: return -1

    # open the output file in modality "mode"
    # and gives back the id
    # if a non-allowed modality is chosen then returns -1
    # mode = file modality
    def idFileOut(self,mode='r'):
        mode=mode.lower()
        if mode=='r' or mode=='w':
            if (not self.fileOut.closed) and (self.fileOut.mode== mode):
                self.fileOut.seek(0)
                return self.fileOut
            else:
                self.fileOut=open(self.nameFileOut,mode)
                self.fileOut.seek(0)
                return self.fileOut
        else: return -1

    # open the temp file in modality "mode"
    # and gives back the id
    # if a non-allowed modality is chosen then returns -1
    # mode = file modality
    def idFileTmp(self,mode='r'):
        mode=mode.lower()
        if mode=='r' or mode=='w':
            if (not self.fileTmp.closed) and (self.fileTmp.mode== mode):
                self.fileTmp.seek(0)
                return self.fileTmp
            else:
                self.fileTmp=open(self.nameFileTmp,mode)
                self.fileTmp.seek(0)
                return self.fileTmp
        else: return -1



    # closes all the files
    def closeFile(self):
        self.fileIn.close()
        if self.fileOut!=None:
            self.fileOut.close()
        self.fileTmp.close()
        self.fileNet.close()
        
    #deletes temp files
    def removeTmpFile(self):
        self.fileTmp.close()
        self.fileNet.close()
        os.remove(self.nameFileTmp)
        os.remove(self.nameFileNet)

    #deletes out file
    def removeFileOut(self):
        if self.fileOut !=None:
            self.fileOut.close()
            os.remove(self.nameFileOut)

        
 
    # reads the input file and gives back the result string
    def readToFileIn(self):
        idFile=self.idFileIn('r')
        idFile.seek(0)
        self.stringIn=idFile.read()
        return self.stringIn
    

    # reads the tmp input file and gives the result string
    def readToFileTmp(self):
        idFile=self.idFileTmp('r')
        idFile.seek(0)
        self.stringTmp=idFile.read()
        return self.stringTmp

    # writes the string in the Output file
    # string = string that has to be written in the out file
    def writeToFileOut(self,string):
        self.stringOut=string
        idFile=self.idFileOut('w')
        idFile.seek(0)
        idFile.write(string)

    # writes the string in the temp file
    # string = string that has to be written in the tmp file
    def writeToFileTmp(self,string):
        self.stringTmp=string
        idFile=self.idFileTmp('w')
        idFile.seek(0)
        idFile.write(string)



    # copies the content of fileIn in the temp file
    def copyFileInToFileTmp(self):
        self.writeToFileTmp(self.readToFileIn())


    # gets back the file in the WWW given as URL
    # returns -1 in case of error
    def retrieve(self,URL):
        URLTuple=urlparse.urlparse(URL)
        
        if URLTuple[0]=='file':
            if (sys.platform[0:3] =="win"): 
                path=URLTuple[2][1:]
            else:
                path=URLTuple[2]
            try:  
                idFile=open(path,'r')  
                idFile.seek(0)
            except IOError:
                return -1
            
            return idFile.read()

        else:
          try:
              urllib.urlretrieve(URL,self.nameFileNet)
          except IOError:
             # return -1
             print 'error'
          urllib.urlcleanup()  #cleans the cache
          idFile=self.fileNet=open(self.nameFileNet,'r')
          idFile.seek(0)
          stringNet=idFile.read()
          idFile.close()
          return stringNet        




    # writes the string in the log file (after creating it)
    # string = string that has to be written in the log file
    def writeToFileLog(self,string):
        nameFileLog=self.nameFileIn.split('.')[0]+'.log'
        try:
           fileLog=open(nameFileLog,'w') #creo il file LOG
        except IOError:
            print 'ERROR: Write log file'
            sys.exit()
        stringLog='Log form file: '+ self.nameFileIn 
        stringLog+=string
        fileLog.seek(0)
        fileLog.write(stringLog)
        fileLog.close()
