# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# Module that generates FeedBack at Metalog level:
# - generates assertions in ML language
# - generates suffixes from annotation N-triples
#********************************************************#

# Import libraries
import os
import time

# Import misc costants
from    definitions     import  *

# Import procedures
from    procedure       import  *

# Import procedures
from    save            import  *

#********************************************************#
# Class for the feedback of the Metalog system
#********************************************************#
class FeedBackClass:

  "Feedback Class of Metalog"
  
  #********************************************************************************************
  # Initialization of the internal data structures
  #********************************************************************************************
  def __init__(self,M):
    self.macro                  = '1'
    self.table_ann_assertions   = []
    self.table_ann_que          = []
    self.data_macro             = []
    self.data_str               = []
    self.tmp_que                = []
    self.M                      = M
    
  #********************************************************************************************
  # Procedure that computes the Metalog feedback
  #********************************************************************************************
  def feed(self, table, data_assertions, data_que, MACRO, MACRO_OK, assertions_name, que_name, CALCULATE_CONT, VIDEO_MESSAGE, NT_FORMAT):
        
    self.macro = MACRO
    if VIDEO_MESSAGE == '1':
      varprint = 1
    elif VIDEO_MESSAGE == '2':
      varprint = 0

    if self.macro == '1':
      self.table_ann_assertions = aggiusta_triple(data_assertions)
      self.table_ann_que = aggiusta_triple(data_que)
  
      # data_assertions and data_que are the tables containing the annotation N-triples

      if data_assertions == -1:
        print("\n  Warning: Error during computation of Annotations Triple of assertions")
        print("  Result and Deduced data cannot be computed with the original annotations of the ML input file.\n\n")
        tmp1 = []
      else:
        tmp1 = self.ricava_tabella('assertions')
      if data_que == -1:
        print("\n  Warning: Error during computation of Annotations Triple of queries")
        print("  Result and Deduced data cannot be computed with the original annotations of the ML input file.\n\n")
        tmp2 = []
      else:
        tmp2 = self.ricava_tabella('que')      
      
      # Compute the table of all the macros (assertions + queries) and the table with only the strings which will be substituted by the macros
      [self.data_macro, self.str] = unify(tmp1, tmp2)

    else:
      [self.data_macro, self.str] = unify([], [])
       
    # Return codes for the Classe Metalog: result is a table that has the following codes for each answer to a query
    # [-1]                - error             "Error during result\n\n"
    # [-2]                - false             "It's false, there are no assertions to unify query."
    # [-3]                - false             "It's false, there are no assertions to unify query."
    # [-4]                - sintax error      "Syntax Error in assertions, it's likely that such assertions cannot be represented in Metalog"
    # [dataass, dataque]  - true              "It's True"
   
    o = 0

    tmp_que = []
    # Cycle analyzing the answers to the queries
    while o < len(table):

      if table[o] == [-1] or table[o] == [-2] or table[o] == [-3] or table[o] == [-4]:

        tmp_que.append(table[o])

      else:

        # Table of answers (warning: there can be more answers for each queries, and multiple queries)
        table_que1 = table[o][1]

        # Analyzes the result table and generates sentences to print
        result_que = self.ricava_frasi(table_que1)

        # Take away from the assertion and queries tables the "double" answers
        result_que = toglidoppie(result_que)

        # Computes the names of the files to be saved on disk
        local_time = time.localtime()
        string = time.asctime(local_time)
        str1 = string[8:10] + string[4:7] + string[22:24] + "-" + string[11:13] + string[14:16] + string[17:19] + "_" + str(o)

        if CALCULATE_CONT == '1':
          result_que = calculate_container(result_que)

        saveresult(ML_RESULT_FOLDER, NT_RESULT_FOLDER, result_que , str1+"_", varprint, NT_FORMAT, self.M, MACRO)

        tmp_que.append(result_que)
        
      o = o + 1
      
    self.tmp_que = tmp_que

  
  #********************************************************************************************
  # Generates table macro assertions/queries
  #********************************************************************************************
  def ricava_tabella(self, choose):
    if choose == 'assertions':
      table = self.table_ann_assertions
    elif choose == 'que':
      table = self.table_ann_que
    else:
      return(-1)
 
    i = 0
    tmp = []
    for el in table:
      if el[1] in ('http://www.w3.org/RDF/Metalog#annotation', 'http://www.w3.org/RDF/Metalog#ns'):
        tmp = inserisci(el, tmp)
    tmp1 = []
    for el in tmp:
      tmp1.append([el[1], el[2], sostituisci(el)])

    return(tmp1)


  #********************************************************************************************
  # Analysis answer string for a query. Generates prefix and string to insert in the answer
  #********************************************************************************************
  def ricava_frasi_assertions(self, data):

    n1 = find_char_norm(data, "'")
    str_tmp = data[n1+1:len(data)]
    n2 = find_char_norm(str_tmp, "'")
    pre = str_tmp[0:n2]
    str_tmp = str_tmp[n2+1:len(str_tmp)]

    elista = islista(str_tmp)
    sub = elista[2]
    obj = elista[3]
    resto = elista[4]
    
    prefix = []
  
    if elista[0] == 0:
      sub1 = self.an_str(sub)
      if sub1[0] != '' and not(sub1[0] in prefix):
          prefix = prefix + [sub1[0]]
      soggetto = sub1[1]
    else:
      list_sub = ricava_lista(sub)
      list_tmp_sub = []
      for el in list_sub:
        sub1 = self.an_str(el)
        if sub1[0] != '' and not(sub1[0] in prefix):
          prefix = prefix + [sub1[0]]
        if sub1[1] == VARINCONTAINER:        
          list_tmp_sub.append(VARINSOGG)
        else:
          list_tmp_sub.append(sub1[1])

      soggetto = ""
      i = 0
      while i < len(list_tmp_sub)-1:
        soggetto = soggetto + list_tmp_sub[i] + " and "
        i = i + 1
      soggetto = soggetto + list_tmp_sub[i] + " in this order"

    if elista[1] == 0:
      obj1 = self.an_str(obj)
      if obj1[0] != '' and not(obj1[0] in prefix):
        prefix = prefix + [obj1[0]]
      oggetto = obj1[1]
    else:
      list_obj = ricava_lista(obj)

      list_tmp_obj = []
      for el in list_obj:
        obj1 = self.an_str(el)
        if obj1[0] != '' and not(obj1[0] in prefix):
          prefix = prefix + [obj1[0]]
        if obj1[1] == VARINCONTAINER:        
          list_tmp_obj.append(VARINOGG)
        else:
          list_tmp_obj.append(obj1[1])
      
      oggetto = ""
      i = 0
      while i < len(list_tmp_obj)-1:
        oggetto = oggetto + list_tmp_obj[i] + " and "
        i = i + 1
      oggetto = oggetto + list_tmp_obj[i] + " in this order"
  
    pre1 = self.an_str(pre)
    if pre1[0] != '' and not(pre1[0] in prefix):
      prefix = prefix + [pre1[0]]
    predicato = pre1[1]

    finale = ''
    continua = 0
    if len(resto) > 2:
      if resto[0:2] == ':-':
        [prefix_fin, finale, codice] = calc_finale(resto[2:len(resto)])
      elif resto[0] == ',':        
        [prefix1, string1] = self.ricava_frasi_assertions(resto[1:len(resto)])
        continua = 1
        string1 = ", and " + string1
      elif resto[0] == ';':
        [prefix1, string1] = self.ricava_frasi_assertions(resto[1:len(resto)])
        continua = 1      
        string1 = ", or " + string1
    else:
      finale = ''

    #####
    if continua == 1:
      for el in prefix1:
        if not(el in prefix):
          prefix = prefix + [el]
      string_out = numero(soggetto) + ' ' + predicato + ' ' + numero(oggetto) + string1

    elif finale == '':
      string_out = numero(soggetto) + ' ' + predicato + ' ' + numero(oggetto)
    
    elif codice == 0:
      for el in prefix_fin:
        if not(el in prefix):
          prefix = prefix + [el]
      string_out = 'if ' + finale + ' then ' + numero(soggetto) + ' ' + predicato + ' ' + numero(oggetto)
      
    else:
      string_out = soggetto + ' ' + predicato + ' ' + finale

    return([prefix, string_out])


  #********************************************************************************************
  # Analysis table containing answers to the queries, and creation of strings to print
  #********************************************************************************************
  def ricava_frasi(self, table):

    prefix = [[]]
    table_str = [[]]
 
    for element in table:
      if element[0]==1:
        out = self.ricava_frasi_assertions(element[1][0][0])
        [prefix, table_str] = insert1(prefix, out[0], table_str, out[1])
    
      elif element[0]==0:
        tmp_pre=[]
        tmp_str=[]
      
        for dat in element[1]:
          out = self.ricava_frasi_assertions(dat[0])
          tmp_pre = tmp_pre + [out[0]]
          tmp_str = tmp_str + [out[1]]
        
        [prefix, table_str] = insert_dup(prefix, tmp_pre, table_str, tmp_str)

    return([prefix, table_str])


  #********************************************************************************************
  # Analysis of string (subject, predicate and object), and generation of the string to insert in the answer
  # and the corresponding prefix (if necessary)
  #********************************************************************************************
  def an_str(self, stringa):
    if stringa[0] == ' ' or stringa[0] == "'":
      stringa = stringa[1:len(stringa)]
    if stringa[len(stringa)-1] == ' ' or stringa[len(stringa)-1] == "'":
      stringa = stringa[0:len(stringa)-1]
      
    esci = 0
    for char in stringa:
      if not(char in NUMERI) and char != '"':
        esci = 1
        break

    if not(esci): # If a number ...
      return(["",stringa])
    else:
      # If a literal 
      if stringa[0] == '"' and stringa[len(stringa)-1] == '"':
        if self.macro == '1':
          return(self.cerca_coppia_prefix_str(stringa))
        else:
          return(["", stringa])

      # Variable (string made up by all upper case chars)
      elif mai(stringa):
        return(["", stringa])

      # In the other cases
      else:
        if self.macro == '1':
          return(self.cerca_coppia_prefix_str(stringa))
        else:
          return(self.calcola_coppia_prefix_str(stringa))
        

  #********************************************************************************************
  # Returns pair [prefix, substituted_string] by looking up the self.data_macro table
  #********************************************************************************************
  def cerca_coppia_prefix_str(self, stringa):
    for el in self.data_macro:
      if el[1] == stringa:
        
        variable = el[0][1:len(el[0])-1]
        
        return([el[2], variable])
      
    return(self.calcola_coppia_prefix_str(stringa))


  #********************************************************************************************
  # Returns the computed pair [prefix, substituted_string] 
  #********************************************************************************************
  def calcola_coppia_prefix_str(self, stringa):

    n = find_char_norm(stringa, '#')
    if stringa[0] == '"':
      return(["", stringa])
    elif mai(stringa):
      return(["", stringa])
    elif stringa[0] == '_':
      return(["", VARINCONTAINER])
    elif n == -1:
      return(["", '"" from "' + stringa + '"'])
    else:
      return(["", '"' + stringa[n+1:len(stringa)] + '" from "' + stringa[0:n] + '"'])



#********************************************************************************************
# Compute the output results by verifying whether or not there are containers Alt or Bag in the answers
# In the affirmative case, it composes them
#********************************************************************************************
def calculate_container(result_que):

  prefix = result_que[0]
  elenco = result_que[1]
  
  table_tmp = []
  for el in elenco:
    table_tmp = table_tmp + separa_str(elenco[0][0])

  table_assertions = table_tmp[0]
#  trasform(table_assertions)
                 
  return result_que


#********************************************************************************************
# Separation of the single strings into an answer to a query
#********************************************************************************************
def separa_str(stringa):
  
  tmp = []
  table_op = []
  str_tmp = stringa
  while 1:
    n1 = find_char_norm(str_tmp, ',')
    if n1 == -1:
      tmp.append(str_tmp)
      break
    else:
      c = str_tmp[n1+2:n1+5]
      if c == 'and':
        oper = 'and'
      else:
        oper = 'or'
      tmp.append(str_tmp[0:n1])
      str_tmp = str_tmp[n1+6:len(str_tmp)]
      table_op.append(oper)
    
  return([tmp, table_op])



#********************************************************************************************
#********************************************************************************************
#********************************************************************************************
# Checks whether or not there are bags in an extended assertion
#********************************************************************************************
def controlla_bag_singolo(assertions, permutazioni):
  for i in range(len(assertions)):
    assertions_i = assertions[0][i]
    [num, resto1, resto2] = sostassertions(assertions_i, permutazioni[0])
 


#********************************************************************************************
#********************************************************************************************
#********************************************************************************************
# Finds subsctitution in a string; returns the remaining part in the assertion, the string, and 
# the index in the permutation table
#********************************************************************************************
def sostassertions(assertions_i, table):
  for i in range(len(table)):
    element = table[i]
    num = len(element)
    for n in range(len(assertions_i)-num+1):
      if assertions_i[n:n+num] == element:
        return(i, assertions_i[0:n-1], assertions_i[n+num:len(assertions_i)])
  
  return(-1, assertions_i, '')
  



#********************************************************************************************
# Procedure that returns all the possible permutations of the input list
#********************************************************************************************
def permut(lista):
  if len(lista)==2:
    return([(lista[0],lista[1]),(lista[1],lista[0])])
  else:
    l=0
    tmp=[]

    while l<len(lista):  
      u=0
      ric=permut(lista[0:l]+lista[l+1:len(lista)])
      
      while(u<len(ric)):
        tmp.append(ric[u]+tuple([lista[l]]))
        u=u+1
      l=l+1
    return(tmp)


#********************************************************************************************
# Orders the table containing the container elements
#********************************************************************************************
def ordinaeaggiustatmp(temp):
  tmp = []
  for i in range(len(temp)): 
    tmp.append('')

  for i in range(len(temp)):
    elemento = temp[i][1]
    elem = riconosci_op(elemento[1:len(elemento)-1])
    num = str2num(elem[2:len(elem)])
    tmp[num-1] = temp[i][2]

  tmp1 = []
  for i in range(len(tmp)):
    el = tmp[i]
    if el[0] == '"':
      tmp1.append(el[0:len(el)-1])
    elif el[0] == '<':
      tmp1.append(el[1:len(el)-2])
    else:
      tmp1.append(VARINCONTAINER)
    
  return(tmp1)
  

#********************************************************************************************
# Formats the table containing the annotations of assertions and query
#********************************************************************************************
def aggiusta_triple(tabella):
  tmp = []
  i = 0
  tmp_tripla = ['', '' ,'']
  for el in tabella:
    if i == 0:
      tmp_tripla[0] = el
      i = i + 1
    elif i == 1:
      tmp_tripla[1] = el[1:len(el)-1]
      i = i + 1      
    elif i == 2:
      if el[0] == '<' and el[len(el)-2] == '>':
        str_tmp = el[1:len(el)-2]
      else:
        str_tmp = el[0:len(el)-1]
      tmp_tripla[2] = str_tmp
      tmp.append(tmp_tripla)
      tmp_tripla = ['', '' ,'']
      i = 0
  return(tmp)


#********************************************************************************************
# Analysis of a string containing a variable
#********************************************************************************************
def inserisci(elemento, tmp):
  anoni = elemento[0]
  temp = tmp
  i = 0
  while i < len(temp):
    el = temp[i]
    if el[0] == anoni:
      if elemento[1] == 'http://www.w3.org/RDF/Metalog#annotation':
        el[1] = elemento[2]
        return(temp)
      elif elemento[1] == 'http://www.w3.org/RDF/Metalog#ns':
        el[2] = elemento[2]
        return(temp)
    i = i + 1
    
  if elemento[1] == 'http://www.w3.org/RDF/Metalog#annotation':
    temp.append([anoni, elemento[2], ''])
  elif elemento[1] == 'http://www.w3.org/RDF/Metalog#ns':
    temp.append([anoni, '', elemento[2]])
  return(temp)
  

#********************************************************************************************
# Computes the substitution string
#********************************************************************************************
def sostituisci(el):
  var = el[1][1:len(el[1])-1]
  secondo = el[2]
  if secondo[0] == '"':
    return(var + ' ' + cost.REPRESENTS[0] + ' ' + secondo)
  else:
    n = find_char_norm(secondo, '#')
    if n != -1:
      return(var + ' ' + cost.REPRESENTS[0] + ' "' + secondo[n+1:len(secondo)] + '" from "' + secondo[0:n] + '"')
    else:
      return(var + ' ' + cost.REPRESENTS[0] + ' "" from "' + secondo[0:len(secondo)] + '"')
      

#********************************************************************************************
# Does a merge between the assertion macro table, and the query macro table
#********************************************************************************************
def unify(tmp1, tmp2):
 
  tmp3 = tmp1

  # Merges the two tables containing the assertion and query macros
  for el in tmp2:
    if not(el in tmp3):
      tmp3 = tmp3 + [el]

  # Computes the table of the possible string substitutions
  tab_str = []
  for el in tmp3:
    tab_str.append(el[2])

  return(tmp3, tab_str)

    


#********************************************************************************************
# Analysis of a string containing a variable
#********************************************************************************************
def cerca_var(stringa):
  tmp = stringa
  i = 0
  num = ''
  while i < len(tmp) and tmp[i] in MAIUSCOLE:
    num = num + tmp[i]
    i = i + 1
  if i == 0:
    return(-1)
  tmp = tmp[i:len(tmp)]
  if tmp[0] == ' ':
    tmp = tmp[1:len(tmp)]
  return(num, tmp)


#********************************************************************************************
# Analysis of a string containing math ops
#********************************************************************************************
def cerca_math(stringa):
  num = find_char_norm(stringa, ',')
  if num != -1:
    stri = stringa[0:num-1]        
    resto = stringa[num:len(stringa)]
  else:
    stri = stringa
    resto = ''
    
  tmp = ''
  for el in stri:
    if not (el in ('(', ')')):
      tmp = tmp + el

  str_tmp = ''
  while tmp != '':
    if tmp[0] in NUMERI:
      [str, tmp] = cerca_num(tmp)
    elif tmp[0] in MAIUSCOLE:
      [str, tmp] = cerca_var(tmp)
    elif tmp[0] == '+':
      str = ' plus '
      tmp = tmp[1:len(tmp)]
    elif tmp[0] == '-':
      str = ' sub '
      tmp = tmp[1:len(tmp)]
    elif tmp[0] == '/':
      str = ' divided by '
      tmp = tmp[1:len(tmp)]
    elif tmp[0] == '*':
      str = ' times '
      tmp = tmp[1:len(tmp)]
    str_tmp = str_tmp + str
    
  return(str_tmp, resto)


#********************************************************************************************
# Analysis of a string containing a number ...
#********************************************************************************************
def cerca_num(stringa):
  tmp = stringa
  i = 0
  num = ''
  while i < len(tmp) and tmp[i] in NUMERI:
    num = num + tmp[i]
    i = i + 1
  if i == 0:
    return(-1)
  tmp = tmp[i:len(tmp)]
  return('"'+num+'"', tmp)


#********************************************************************************************
# Analysis of a string containing a comparison predicate
#********************************************************************************************
def cerca_pred(stringa):
  tmp = stringa  
  car1 = tmp[0:1]
  if len(tmp)>1:
    car2 = tmp[0:2]
  else:
    car2 = ' '
  if len(tmp)>2:
    car3 = tmp[0:3]
  else:
    car3 = ' '

  if car1 in PREDICATI_SWI or car1 in PREDICATI_PY:
    if car1 == '<':
      pred = ' less than '
    elif car1 == '>':
      pred = ' greater than '
    tmp = tmp[1:len(tmp)]
  elif car2 in PREDICATI_SWI or car2 in PREDICATI_PY:
    if car2 == '==':
      pred = ' equal to '
    elif car2 == '<=':
      pred = ' less equal than '
    elif car2 == '>=':
      pred = ' great equal than '
    tmp = tmp[2:len(tmp)]
  elif car3 in PREDICATI_SWI or car3 in PREDICATI_PY:
    if car3 == '=\=' or car3 == '\==':
      pred = ' different to ' 
    tmp = tmp[3:len(tmp)]
  else:
    return(-1)
  
  return(pred, tmp)


#********************************************************************************************
# Analyze the "left side of the imply" part of the answer string
#********************************************************************************************
# returns : [table with computed prefixes, string, code: 0-normal assertion, 1-math op]
def calc_finale(stringa):

  if stringa == '':
    return([[], '', 0])
  if stringa[0] == ' ':
    stringa = stringa[1:len(stringa)]
  if stringa == '':
    return([[], '', 0])
  elif stringa[0] == ',': # and
    stringa = stringa[1:len(stringa)]
    [pre, str, num] = calc_finale(stringa)
    return([pre, ' and '+str,0])
  elif stringa[0] == ';': # or 
    stringa = stringa[1:len(stringa)] 
    [pre, str, num] = calc_finale(stringa)
    return([pre, ' or '+str,0])
  
  prefix = []
  tmp = stringa
  if tmp[0] in NUMERI: # Comparison predicate
    [primo, tmp] = cerca_num(tmp)
    [pred, tmp] = cerca_pred(tmp)
    if tmp[0] in NUMERI:
      [secondo, tmp] = cerca_num(tmp)
    elif tmp[0] in MAIUSCOLE:
      [secondo, tmp] = cerca_var(tmp)
    out = primo + pred + secondo
    if tmp != '':
      if tmp[0] == ' ':
        tmp = tmp[1:len(tmp)]
      if  resto == '':
         return([[], '', 0])
      else:    
        [pre_ric, out_ric] = calc_finale(tmp)
        return(pre_ric, out + out_ric)
    else:
      return([[], out, 0])

  elif tmp[0] in MAIUSCOLE:
    [primo, tmp] = cerca_var(tmp)
    if tmp[0:len(cost.REPRESENTS[0])] == cost.REPRESENTS[0]: # Math op
      tmp = tmp [3:len(tmp)]
      [math, tmp] = cerca_math(tmp)
      return([[], math, 1])
      
    else: # Comparison predicates
      [pred, tmp] = cerca_pred(tmp)
      if tmp[0] in NUMERI:
        [secondo, tmp] = cerca_num(tmp)
      elif tmp[0] in MAIUSCOLE:
        [secondo, tmp] = cerca_var(tmp)
      out = primo + pred + secondo
      if tmp != '':
        if tmp[0] == ' ':
          tmp = tmp[1:len(tmp)]
        if  resto == '':
         return([[], '', 0])
        else:
          [pre_ric, out_ric] = calc_finale(tmp)
          return(pre_ric, out + out_ric)
      else:
        return([[], out, 0])
      
  else:
    n1 = find_char_norm(stringa, ')')
    resto = stringa[n1+1:len(stringa)]
    
    [pre, stri] = self.ricava_frasi_assertions(stringa[0:n1+1])
    if  resto != '':
      if resto[0] == ' ':
        resto = resto[1:len(resto)]
      if  resto == '':
         return([[], '', 0])
      else:
        [pre_ric, out_ric] = calc_finale(resto)
        return(pre + pre_ric, stri + out_ric)
    else:
      return([pre, stri, 0])
  


#********************************************************************************************
# Print the results of an assertions or a query
#********************************************************************************************
def printout(dat_out, stringa):

  print "-"*50
  if stringa == 'assertions':
    print "Assertions list:"
  elif stringa == 'que':
    print "Query answers:"
  i=0
  stringa=""
  while i < len(dat_out)-1:
      
    temp = dat_out[i]

    if temp[0] == 1:
      temp1 = temp[1][0]
      stringa="   - "+str(temp1[0])+"  and"

    elif temp[0] == 0:
      temp1 = temp[1]
      k = 0
      stringa = "   - [\n"
      while k < len(temp1)-1:
        stringa = stringa + str(temp1[k][0])+"\n"
        k = k+1
      stringa = stringa + str(temp1[k][0])+"\n    ] and"
    else:
      return("")
    i = i+1
    
  temp = dat_out[i]

  if temp[0] == 1:
    temp1 = temp[1][0]
    stringa ="   - "+str(temp1[0])

  elif temp[0] == 0:
    temp1 = temp[1]
    k = 0
    stringa = "-   [\n"
    while k < len(temp1)-1:
      stringa = stringa + str(temp1[k][0])+"\n"
      k = k+1
    stringa = stringa + str(temp1[k][0])+"\n    ]"
  else:
    return("")
  i = i+1


#********************************************************************************************
# Take away from the assertion and queries tables the "double" answers
#********************************************************************************************
def toglidoppie(data):
  prefix = data[0]
  stringhe = data[1]
  pre_tmp = []
  stri_tmp = []

  i = 0
  while i < len(prefix):
    u = find_el(prefix[i], pre_tmp)
    eccolo = 0
    for u1 in u:
      if stringhe[i] == stri_tmp[u1]:
        eccolo = 1
    if not(eccolo):
      pre_tmp = pre_tmp + [prefix[i]]
      stri_tmp = stri_tmp + [stringhe[i]]
    
    i = i + 1
  return([pre_tmp, stri_tmp])


#********************************************************************************************
# Finds an element in a list
#********************************************************************************************
def find_el(pre, tmp):
  i = 0
  temp = []
  while i < len(tmp):
    if tmp[i] == pre:
      temp = temp + [i]
    i = i + 1
  return(temp)


#********************************************************************************************
# Duplicates the prefix tables and adds to each of them the table_prefix table
#********************************************************************************************
def insert_dup(prefix, table_prefix, table_str, table):
  tmp1 = []
  tmp2 = []
  i = 0
  while i < len(table_prefix):
    el1 = table_prefix[i]
    el2 = table[i]
    t1 = copylist(prefix)
    t2 = copylist(table_str)

    [a1, a2] = insert1(t1, el1, t2, el2)

    tmp1 = tmp1 + a1
    tmp2 = tmp2 + a2
    i= i + 1

  return([tmp1, tmp2])


#********************************************************************************************
# Inserts in the prefix table all the prefixes contained in table
#********************************************************************************************
def insert1(prefix, table, table_str, str):
  pre1 = copylist(prefix)
  t1 = copylist(table)
  s = copylist(str)
  t2 = copylist(table_str)
  i=0
  while i < len(pre1):
    if not(edentro(table, str, prefix[i], table_str[i])):
      for dat in t1:
        if not(dat in pre1[i]):
          pre1[i] = pre1[i] + [dat]
#    pre1[i] = pre1[i] + t1
      t2[i] = t2[i] + [s]
    i = i + 1
      
  return([pre1, t2])


#********************************************************************************************
# Inserts in the prexif table all the prefixes contained in table
#********************************************************************************************
def edentro(table, str, pre, tab):

  if str in tab:
    for el in table:
      if not(el in pre):
        return(0)
    return(1)
  else:
    return(0)


#********************************************************************************************
# Generates a list of strings from a single string enclosed within square brackets
#********************************************************************************************
def ricava_lista(stringa):

  # Missing: handling of variables in the lists!
  tmp = stringa[1:len(stringa)-1]
  lista = []
  n = 1
  while 1:
    if tmp[0] == ' ':
      tmp = tmp[1:len(tmp)]
    if tmp[len(tmp)-1] == ' ':
      tmp = tmp[0:len(tmp)-1]
    n = find_char_norm(tmp, ',')
    if n != -1:
      str1 = tmp[0:n]
      if str1[0] == "'":
        str1 = str1[1:len(str1)]
      if str1[len(str1)-1] == "'":
        str1 = str1[0:len(str1)-1]      
      tmp = tmp[n+1:len(tmp)]
      lista.append(str1)
    else:
      if tmp[0] == "'":
        tmp = tmp[1:len(tmp)]
      if tmp[len(tmp)-1] == "'":
        tmp = tmp[0:len(tmp)-1]
      lista.append(tmp[0:len(tmp)])
      return(lista)


#********************************************************************************************
# Analysis of the string containing subject and predicate
# Returns:
# - [0, 0, sub, obj] if subject and object are not lists,
# - [1, 0, sub, obj] if subject is a list,
# - [0, 1, sub, obj] if object is a list,
# - [1, 1, sub, obj] if subject and object are lists.
#********************************************************************************************
def islista(stringa):
  
  n1 = find_char_norm(stringa, '(')
  n2 = find_char_norm(stringa, ')')

  tmp = stringa[n1+1:n2]
  
  if tmp[0] == ' ':
    tmp = tmp[1:len(tmp)]
  if tmp[len(tmp)-1] == ' ':
    tmp = tmp[0:len(tmp)-1]

  if tmp[0] == '[':
    n3 = find_char_norm(tmp, ']')
    sub_list = 1
  else:
    n3 = find_char_norm(tmp, ',')-1
    sub_list = 0

  sub = tmp[0:n3+1]
  tmp = tmp[n3+2:len(tmp)]

  if tmp[0] == ' ':
    tmp = tmp[1:len(tmp)]
  if tmp[len(tmp)-1] == ' ':
    tmp = tmp[0:len(tmp)-1]

  if tmp[0] == '[':
    n3 = find_char_norm(tmp, ']')
    obj_list = 1
  else:
    n3 = find_char_norm(tmp, ',')-1
    obj_list = 0

  obj = tmp[0:n3+1]

  if sub[0] == "'":
    sub = sub[1:len(sub)]
  if tmp[len(tmp)-1] == "'":
    sub = sub[0:len(sub)-1]
  if obj[0] == "'":
    obj = obj[1:len(obj)]
  if obj[len(obj)-1] == "'":
    obj = obj[0:len(obj)-1]

  resto = stringa[n2+1:len(stringa)]

  return([sub_list, obj_list, sub, obj, resto])



