# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
# This module defines the class -Error-
# that handles the error messages both for MetalogEdit
# and for the text command line

import sys

if 'cost' in dir(): 
    reload(cost)
else: import cost


# The error class handles errors by interrupting the program,
# printing on the screen (or in the graphical interface) the error
# and signaling the point where it occurs
class Error:

    # this class is initialized by giving in input
    # ED = instance of the -editor- class the handles the graphical interface
    # if ED=None handles the errors in the command line mode
    
    def __init__(self,ED,MM=None,log='no'):
        if ED==None:      
            self.interface=0
        else:
            self.interface=1
        self.ED=ED

        self.MM=MM
        

    # prints a message in the graphical interface
    # string = the message to print
    def printMessage(self,string):
        self.ED.messageDebug(string)


    # print an error message in the graphical interface
    # and signals the position of the error
    # F = instance of the file object used to signal the potision of the file
    # msgErr = output error message
    # posixFileTmp = error position in the temp file
    # posixFileIn = error position in the input file
    # exit = flag, if equal to 'yes' interrupts the program

    def errorToFile(self,F,msgErr,posixFileTmp,exit='yes'):
        if self.interface==1:
            if F!=None:
                resTmp=self.colRow(F.stringTmp,posixFileTmp)
                if resTmp!=-1:
                    [row,col]=resTmp
                    lineCodeTmp=F.stringTmp.split('\n')
                    lineCodeIn=F.stringIn.split('\n')
                    self.ED.messageDebug(msgErr,row,col)  # graphical interface
                else:
                    self.ED.messageDebug(msgErr,-1,-1)  # graphical interface
            else:
                self.ED.messageDebug(msgErr,-1,-1)  # grapical interface

            F.removeTmpFile() #deletes the temp file
            F.closeFile() #closes the open files

            
            raise "ErrorCode"  #raises an error exception in the code
                
    
        else:   #graphical interface handling
            if F!=None:
                stringErr=''
                resTmp=self.colRow(F.stringTmp,posixFileTmp)
                if resTmp!=-1:
                    [row,col]=resTmp
                    lineCode=F.stringIn.split('\n')
                    stringErr+= '\n\n-->  '
                    stringErr+=  lineCode[row-1]+'\n\n'
                    stringErr+= msgErr+'\n'
                    stringErr+= '(line: '+ str(row) + ', file: ' +F.nameFileIn +')\n\n'
                else:
                    stringErr+= msgErr              
            else:
                stringErr+= msgErr

            F.removeTmpFile() #deletes temp files
            F.removeFileOut() #deletes the out file as there is an error
            F.closeFile() #closes open files

            if cost.ERROR=='onlylog' and  self.MM!=None:   # Do not print error but save the log file
                self.MM.saveToFileLog(stringErr)
            if cost.ERROR=='onlyprint': #Print error but do not save file
                print stringErr
            if cost.ERROR=='all' and  self.MM!=None: #Printe error and save log file
                self.MM.saveToFileLog(stringErr)
                print stringErr
            sys.exit()
                
       
 

    # gives back the coordinate (row, colums)
    # corresponding to the position in the string
    # if the position is out of the row then -1 is returned
    # string = string where to find the coordinates
    # posix = position in the string
    def colRow(self,string,posix):
        i=-1
        row=1
        col=-1
        for char in string:
            i+=1
            col+=1
            if char=='\n' and posix!=i:
                row+=1
                col=-1
                continue
            if posix==i:
                return [row,col]
        return -1





