# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# Module that defines the constants to use in the other modules
#********************************************************#

import os
import os.path
import sys
from string import *

##########################################################################
# Definition of work directory, input and output files
##########################################################################

try:
    os.chdir(os.path.dirname(__file__))
except:
    pass

DIR_WORK= os.getcwd()
DIR_LIB= os.path.normpath(os.path.join(DIR_WORK,'lib'))
BARRA= os.sep

if (sys.platform[0:3] =="win"):
    OP_SYSTEM = "win" #Windows-like operating system
else:
    OP_SYSTEM = "nonwin" #in fact, we assume it is Linux-friendly.

if not(DIR_LIB in sys.path):
    sys.path.append(DIR_LIB)




ML_DEDUCED_FOLDER   = os.path.normpath(os.path.join(DIR_WORK,'output_files/deduced/ml'))
NT_DEDUCED_FOLDER   = os.path.normpath(os.path.join(DIR_WORK,'output_files/deduced/nt'))
ML_RESULT_FOLDER    = os.path.normpath(os.path.join(DIR_WORK,'output_files/result/ml'))
NT_RESULT_FOLDER    = os.path.normpath(os.path.join(DIR_WORK,'output_files/result/nt'))
DIALOGUES_FOLDER    = os.path.normpath(os.path.join(DIR_WORK,'dialogues'))
NT_FOLDER           = os.path.normpath(os.path.join(DIR_WORK,'input_nt'))
PL_FILE_SINGLE      = os.path.normpath(os.path.join(DIR_LIB,'metalog1.pl'))
PL_FILE_MULTI       = os.path.normpath(os.path.join(DIR_LIB,'metalog2.pl'))
METAPYLOG           = os.path.normpath(os.path.join(DIR_LIB,'metapylog.pl'))
CONFIG_FILE         = os.path.normpath(os.path.join(DIR_LIB,'config.cfg'))
DEFAULT_CONFIG      = os.path.normpath(os.path.join(DIR_LIB,'default.cfg'))

# Temp files
TMP_FOLDER          = os.path.normpath(os.path.join(DIR_LIB,'temp'))
PIPEIN              = os.path.normpath(os.path.join(TMP_FOLDER,'pipein.tmp'))
PIPEOUT             = os.path.normpath(os.path.join(TMP_FOLDER,'pipeout.tmp'))
NAMETMP             = os.path.normpath(os.path.join(TMP_FOLDER,'temp.tmp'))
OK                  = os.path.normpath(os.path.join(TMP_FOLDER,'ok.tmp'))
TMP_ASSERTION       = os.path.normpath(os.path.join(TMP_FOLDER,'assertiontmp.ml'))

###########
VARINCONTAINER      = 'VARINCONTAINER'
VARINSOGG           = 'AAAAAAAAAA'
VARINOGG            = 'BBBBBBBBBB'

##########################################################################
# Definition of significant keywords sets
##########################################################################
CONTAINER           = ("bag","seq","alt")
LOGIC               = ("and","or","not","implies")
PRED_CONFR          = ("eq","neq","less","great","leq","geq")
MATH                = ("add","divide","sub","times")

##########################################################################
# Definition of the types "LIST" and "TUPLE"
##########################################################################
LIST_TEST           = []
TYPELIST            = type(LIST_TEST)
TUPLE_TEST          = ()
TYPETUPLE           = type(TUPLE_TEST)
STRING_TEST         = ""
TYPESTRING          = type(STRING_TEST)

##########################################################################
# Definition of the allowed chars in (alphanumeric) names
##########################################################################
NUMERI              = (u'\u0030',u'\u0031',u'\u0032',u'\u0033',u'\u0034',u'\u0035',u'\u0036',u'\u0037',u'\u0038',u'\u0039')
ALFA                = (u'\u0041',u'\u0042',u'\u0043',u'\u0044',u'\u0045',u'\u0046',u'\u0047',u'\u0048',u'\u0049',u'\u004A',u'\u004B',u'\u004C',u'\u004D',u'\u004E',u'\u004F',
                       u'\u0050',u'\u0051',u'\u0052',u'\u0053',u'\u0054',u'\u0055',u'\u0056',u'\u0057',u'\u0058',u'\u0059',u'\u005A',
                       u'\u0061',u'\u0062',u'\u0063',u'\u0064',u'\u0065',u'\u0066',u'\u0067',u'\u0068',u'\u0069',u'\u006A',u'\u006B',u'\u006C',u'\u006D',u'\u006E',u'\u006F',
                       u'\u0070',u'\u0071',u'\u0072',u'\u0073',u'\u0074',u'\u0075',u'\u0076',u'\u0077',u'\u0078',u'\u0079',u'\u007A',
                       u'\u0022')

MAIUSCOLE           = (u'\u0041',u'\u0042',u'\u0043',u'\u0044',u'\u0045',u'\u0046',u'\u0047',u'\u0048',u'\u0049',u'\u004A',u'\u004B',u'\u004C',u'\u004D',u'\u004E',u'\u004F',
                       u'\u0050',u'\u0051',u'\u0052',u'\u0053',u'\u0054',u'\u0055',u'\u0056',u'\u0057',u'\u0058',u'\u0059',u'\u005A',)
MINUSCOLE           = (u'\u0061',u'\u0062',u'\u0063',u'\u0064',u'\u0065',u'\u0066',u'\u0067',u'\u0068',u'\u0069',u'\u006A',u'\u006B',u'\u006C',u'\u006D',u'\u006E',u'\u006F',
                       u'\u0070',u'\u0071',u'\u0072',u'\u0073',u'\u0074',u'\u0075',u'\u0076',u'\u0077',u'\u0078',u'\u0079',u'\u007A')


##########################################################################
# Definition of comparison ops for SWI
##########################################################################
EQ_SWI              = '=:='
NEQ_SWI             = '=\='
L_SWI               = '<'
G_SWI               = '>'
LEQ_SWI             = '=<'
GEQ_SWI             = '>='
PREDICATI_SWI       = ('=:=', '=\=', '<', '>', '=<', '>=')

##########################################################################
# Definition of comparison ops for Pylog
##########################################################################
EQ_PYL              = '=='
NEQ_PYL             = '\=='
L_PYL               = '<'
G_PY                = '>'
LEQ_PY              = '<='
GEQ_PY              = '>='
PREDICATI_PY        = ('==', '\==', '<', '>', '<=', '>=')


##########################################################################
# COLOR DEFINITION
##########################################################################
COLOR_COMMENT = '#FF0000'
COLOR_MACRO = '#339900'
COLOR_ASSERT = '#0033FF'
COLOR_NTRIPLE = '#0033FF'
BAGR_ASSERT = '#FFFFCC'
BAGR_NT = '#FFFFCC'

