/**
 * Copyright  Sergey Melnik (Stanford University, Database Group) 
 *
 * Distribution policies are governed by the W3C software license.
 * http://www.w3.org/Consortium/Legal/copyright-software   
 * 
 * All Rights Reserved.
 *
 * @author      Sergey Melnik <melnik@db.stanford.edu>
 */

package org.w3c.rdf.util.xml;

import java.util.*;

public class Element {

  public static final String EMPTY_STR = "";
  public static final int EMPTY = 0;
  public static final int CDATA = 1;
  public static final int ELEMENTS = 2;
  public static final int MIXED = CDATA | ELEMENTS;

  public static final Enumeration EMPTY_ENUMERATION = new Enumeration() {

    public boolean hasMoreElements() {
      return false;
    }
    public Object nextElement() {
      throw new NoSuchElementException("ElementEnumerator");
    }
  };

  protected int type = EMPTY;
  protected Element parent;
  /**
   * we consider a single child at a time
   */
  protected Element child;
  protected String name;
  /**
   * If element is CDATA
   */
  protected String value = EMPTY_STR;
  protected Hashtable attrs;

  public Element() {
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public int getType() {
    return type;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
    type |= CDATA;
  }

  public Element getParent() {
    return parent;
  }

  public void setParent(Element parent) {
    this.parent = parent;
  }

  public void setChild(Element child) {
    this.child = child;
    type |= ELEMENTS;
  }

  public Enumeration getAttributes() {

    if(attrs == null)
      return EMPTY_ENUMERATION;
    else
      return attrs.keys();
  }

  public void setAttribute(String name, String value) {

    if(attrs == null)
      attrs = new Hashtable();
    attrs.put(name, value);
  }

  public String getAttribute(String name) {

    if(attrs == null)
      return null;
    else
      return (String)attrs.get(name);
  }
}
