/**
 * Copyright  Sergey Melnik (Stanford University, Database Group) 
 *
 * Distribution policies are governed by the W3C software license.
 * http://www.w3.org/Consortium/Legal/copyright-software   
 * 
 * All Rights Reserved.
 * 
 * @author      Sergey Melnik <melnik@db.stanford.edu>
 */

package org.w3c.rdf.util;

import org.w3c.rdf.model.*;
import org.w3c.rdf.syntax.*;
import org.w3c.rdf.implementation.model.*;
import org.w3c.rdf.implementation.syntax.sirpac.*;

/**
 * A default implementation of the RDFFactory interface.
 *
 * @author Sergey Melnik <melnik@db.stanford.edu>
 */

public class RDFFactoryImpl implements RDFFactory {

  public RDFFactoryImpl() {
  }

  public RDFParser createParser() {
    SiRPAC parser = new SiRPAC();
    parser.setRobustMode(true);
    return parser;
  }

  public RDFSerializer createSerializer() {
    return new SiRS();
  }

  public Model createModel() {
    return new ModelImpl();
  }
}
