/**
 * Copyright  Sergey Melnik (Stanford University, Database Group) 
 *
 * Distribution policies are governed by the W3C software license.
 * http://www.w3.org/Consortium/Legal/copyright-software   
 * 
 * All Rights Reserved.
 * 
 * @author      Sergey Melnik <melnik@db.stanford.edu>
 */

package org.w3c.rdf.syntax;

import org.w3c.rdf.model.*;
import java.io.Writer;
import java.io.IOException;

/**
 * RDF serializer interface.
 */

public interface RDFSerializer {

  /**
   * Serialize a given model into an XML character output stream.
   */
  public void serialize(Model model, Writer w) throws SerializationException, IOException, ModelException;

}
