/**
 * Copyright  Sergey Melnik (Stanford University, Database Group) 
 *
 * Distribution policies are governed by the W3C software license.
 * http://www.w3.org/Consortium/Legal/copyright-software   
 * 
 * All Rights Reserved.
 * 
 * @author      Sergey Melnik <melnik@db.stanford.edu>
 */

package org.w3c.rdf.examples;

import java.util.*;
import org.w3c.rdf.model.*;
import org.w3c.rdf.util.*;

public class ListStatements {

    static void bailOut() {
	System.err.println("Usage: java -Dorg.xml.sax.parser=<classname> org.w3c.rdf.examples.ListStatements " +
			   "<URI | filename>");
	System.exit(1);
    }

    public static void main(String[] args) throws Exception {

	if(args.length != 1)
	    bailOut();
	
	RDFFactory f = new RDFFactoryImpl();
	Model m = f.createModel();
	RDFUtil.parse(args[0], f.createParser(), m);
	
	for(Enumeration en = m.elements(); en.hasMoreElements();) {
	    
	    Statement s = (Statement)en.nextElement();
	    System.out.println("Statement " + s + " has digest URI " + s.getURI());
	}
    }
}
