/**
 * Copyright  Sergey Melnik (Stanford University, Database Group) 
 *
 * Distribution policies are governed by the W3C software license.
 * http://www.w3.org/Consortium/Legal/copyright-software   
 * 
 * All Rights Reserved.
 *
 * @author      Sergey Melnik <melnik@db.stanford.edu>
 */

package org.w3c.rdf.util.xml;

import org.w3c.rdf.model.*;
import org.w3c.rdf.syntax.*;
import org.w3c.rdf.implementation.model.StatementImpl;
import org.w3c.rdf.implementation.model.NodeFactoryImpl;

public class DumpConsumer implements RDFConsumer {
      
  int num = 0;
  NodeFactory f = new NodeFactoryImpl();

  public void startModel () {}
  public void endModel () {
    System.out.println("Total statements: " + num);
  }

  public NodeFactory getNodeFactory() {
    return f;
  }

  public void addStatement (Statement s) {
    System.out.println(s.toString());
    num++;
  }
}
