/**
 * Copyright  Sergey Melnik (Stanford University, Database Group) 
 *
 * Distribution policies are governed by the W3C software license.
 * http://www.w3.org/Consortium/Legal/copyright-software   
 * 
 * All Rights Reserved.
 * 
 * @author      Sergey Melnik <melnik@db.stanford.edu>
 */

package org.w3c.rdf.tools.crypt;

/**
 * A cryptographic digest
 *
 * @see org.w3c.rdf.tools.crypt.Digestable
 * @see org.w3c.rdf.tools.crypt.DigestUtil
 */

public interface Digest {

  public String MD5 = "MD5";
  public String SHA1 = "SHA-1";

  public String getDigestAlgorithm() throws DigestException;
  public byte[] getDigestBytes() throws DigestException;
}
