/**
 * Copyright  World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 *
 * Distribution policies are governed by the W3C software license.
 * http://www.w3.org/Consortium/Legal/copyright-software   
 *
 * All Rights Reserved.
 * 
 * @author      Sergey Melnik <melnik@db.stanford.edu>
 */

package org.w3c.rdf.model;

/**
 * An RDF resource
 */

public interface Resource extends RDFNode {

  /**
   * Returns the URI of the resource. Triples and models must implement this method in a standard way.
   * @return the URI of the resource
   *
   * @see org.w3c.rdf.model.Triple
   * @see org.w3c.rdf.model.RDFModel
   */
  public String getURI() throws ModelException;

}
