/**
 * Copyright  Sergey Melnik (Stanford University, Database Group) 
 *
 * Distribution policies are governed by the W3C software license.
 * http://www.w3.org/Consortium/Legal/copyright-software   
 * 
 * All Rights Reserved.
 * 
 * @author      Sergey Melnik <melnik@db.stanford.edu>
 */

package org.w3c.rdf.model;

/**
 * Provides methods for creating resources, literals and statements.
 */

public interface NodeFactory {

  /**
   * Creates a resource out of a string
   */
  public Resource createResource(String str) throws ModelException;

  /**
   * Creates a literal out of a string
   */
  public Literal createLiteral(String str) throws ModelException;

  /**
   * Creates a triple
   */
  public Statement createStatement(Resource subject, Resource predicate, RDFNode object) throws ModelException;

  /**
   * Creates a resource with a unique ID
   */
  public Resource createUniqueResource() throws ModelException;

  /**
   * Creates an ordinal
   */
  public Resource createOrdinal(int i) throws ModelException;

}
