/**
 * Copyright  Sergey Melnik (Stanford University, Database Group) 
 *
 * Distribution policies are governed by the W3C software license.
 * http://www.w3.org/Consortium/Legal/copyright-software   
 * 
 * All Rights Reserved.
 * 
 * @author      Sergey Melnik <melnik@db.stanford.edu>
 */

package org.w3c.rdf.implementation.model;

import org.w3c.rdf.model.*;
import org.w3c.rdf.util.*;
import org.w3c.rdf.tools.crypt.*;

public abstract class RDFNodeImpl implements RDFNode, Digestable {
  private boolean _alreadyComputedHashcode = false;
  private int _hashCode;

  protected String label;
  protected Digest digest;

  protected RDFNodeImpl() {
  }

  public RDFNodeImpl(String label) {
    this.label = label;
  }

  public String	toString () {
    return label;
  }

  public String	getLabel () {
    return label;
  }

  public int hashCode() {
   if (false == _alreadyComputedHashcode)
   {
    try
    {
     _hashCode = DigestUtil.getHashCode(getDigest());
    }
    catch (DigestException exc)
    {
    _hashCode = super.hashCode();
    }
   }
   return _hashCode;
  }

  // implementation of Digestable

  public Digest getDigest() throws DigestException {

    if(digest == null) {
      try {
	digest = RDFDigestUtil.computeNodeDigest(this);
      } catch (ModelException exc) {
	throw new DigestException(exc.toString());
      }
    }
    return digest;
  }

  public boolean equals (Object that) {

    if(that instanceof Digestable) {
      try {
	return DigestUtil.equal(getDigest(), ((Digestable)that).getDigest());
      } catch (DigestException any) {}
    }

    try {
      return label.equals( ((RDFNode)that).getLabel() );
    } catch (ModelException ex) {
      return false;
    }
  }
}
