/**
 * DumpConsumer for the SiRPACServlet
 *
 * Copyright  World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 *
 * All Rights Reserved.
 *
 * Please see the full Copyright clause at
 * <http://www.w3.org/Consortium/Legal/copyright-software.html>
 *
 * @author Arthur Barstow <barstow@w3.org>
 */
package org.w3c.rdf.examples;

import java.io.*;
import org.w3c.rdf.model.*;
import org.w3c.rdf.syntax.*;
import org.w3c.rdf.util.xml.DumpConsumer;
import org.w3c.rdf.implementation.model.NodeFactoryImpl;
import javax.servlet.ServletOutputStream;

public class SiRPACServletDumpConsumer extends DumpConsumer implements RDFConsumer {
    private NodeFactory         m_f = new NodeFactoryImpl();
    private ServletOutputStream m_out = null;
    private int                 m_numStatements = 0;

    public void startModel () {}
    public void endModel () {}

    public void setOutputStream (ServletOutputStream out) {
        m_out = out;
    }

    public NodeFactory getNodeFactory() {
        return m_f;
    }

    public int getNumStatements() {
        return m_numStatements;
    }

    public void addStatement (Statement s) {

        try {
            /*
             * If the object contains XML markup characters, must convert 
             * them to entity chars.
             */
            String tmpObjectName = new String(s.object().toString());

            if (tmpObjectName != null) {
                tmpObjectName = SiRPACServlet.replaceString(tmpObjectName, "<", "&lt;");
                tmpObjectName = SiRPACServlet.replaceString(tmpObjectName, ">", "&gt;");
            } else {
                tmpObjectName = " ";
            }

            if (m_out == null)
                System.out.println ("triple('" + s.predicate() + "',\n"
                                  + "       '" + s.subject() + "',\n"
                                  + "       '" + tmpObjectName + "').");
            else
                m_out.println ("triple('" + s.predicate() + "',\n"
                             + "       '" + s.subject() + "',\n"
                             + "       '" + tmpObjectName + "').");
            m_numStatements++;
        } catch (Exception e) {
            e.printStackTrace ();
            return;
        }
    }
}
