package w3c.model.www.pep.extensions.remoteControl;

import w3c.model.www.pep.*;
import w3c.model.www.pep.altlib.HttpParserException;
import w3c.model.www.pep.altlib.HTTPException;
import w3c.model.www.pep.altlib.Informer;
import java.util.Enumeration;

abstract public class Common extends PEPExtension {
    final static String prefHeaderName = "RemoCon-";
    protected final static String absoluteURI = "http://localhost:8887/src/classes/remoteControl";

    public Common () {}

    public void initialize (PEPAgent pepAgent, boolean requiredExtension, Informer informer) {
	super.initialize(pepAgent, absoluteURI, informer);
    }

    public boolean map (InstanceContext instanceContext, int when, PEPMessage message, String reason) {
	return false;
    }

    abstract void generateHeader (PEPExtensionInstance inst, InstanceContext instanceContext, PEPMessage message);
    public boolean generateHeaders (InstanceContext instanceContext, int when) throws HTTPException {
	if (when != PEPExtension.CONNECT)
	    return false;
	PEPMessage message = instanceContext.getMessage();
	Enumeration key = instanceContext.getExtensionInstances(this);
	ClientInstance inst;
	while (key.hasMoreElements())
	    generateHeader((PEPExtensionInstance)key.nextElement(), instanceContext, message);
        return true;
    }

    abstract void handleHeader (PEPExtensionInstance inst, PEPMessage message);
    public boolean handleHeaders (InstanceContext instanceContext, int when) throws HTTPException {
	if (when != PEPExtension.HEADERS)
	    return false;
	PEPMessage message = instanceContext.getMessage();
	Enumeration key = instanceContext.getExtensionInstances(this);
	while (key.hasMoreElements())
	    handleHeader((PEPExtensionInstance)key.nextElement(), message);
	return true;
    }

}

