package w3c.model.www.pep.extensions.remoteControl;

import w3c.model.www.pep.*;
import w3c.model.www.pep.bags.*;
import w3c.model.www.pep.altlib.HTTPException;

public class Client extends Common {

    w3c.model.tools.basicweb.Client client;
    int instructionNumber = 0;
    String baseHeader;
    public Client (w3c.model.tools.basicweb.Client client, PEPAgent pepAgent) {
	this.client = client;
	baseHeader = pepAgent.nextFreeName(prefHeaderName, this, true);
    }

    public PEPExtensionInstance makeInstance (InstanceContext instanceContext, String cmd) {
	String headerName = baseHeader + String.valueOf(instructionNumber++);
	ClientInstance ret = new ClientInstance(headerName, cmd, informer);
/* this extension self-adds it instances to the instanceContext for this mesage */
	instanceContext.addExtensionInstance(this, ret);
	return ret;
    }

    public PEPExtensionInstance makeInstance (String headerNames[], int headerNameCount, InstanceContext instanceContext) {
	throw new InternalError("illegal call to default remoteControl.Client.makeInstance("+headerNames[0]+").");
    }

    public boolean generateHeaders (InstanceContext instanceContext, int when) throws HTTPException {
	if (when != PEPExtension.CONNECT)
	    return false;
	String headerNames[] = new String[1];
	boolean wilds[] = new boolean[1];
	headerNames[0] = baseHeader;
	wilds[0] = true;
	ExtDecl extDecl = new ExtDecl(instanceContext, 
	    new MapBag(instanceContext, URI, headerNames, wilds, 1), 
	    new StrengthBag(instanceContext, true));
		
//	instanceContext.addExtensionInstance(this, makeInstance(headerNames, 1, instanceContext));
	instanceContext.addExtDecl(extDecl, PEPMessage.PEP);
	return super.generateHeaders(instanceContext, when);
    }

    void generateHeader (PEPExtensionInstance inst, InstanceContext instanceContext, PEPMessage message) {
    	ClientInstance clientInstance = (ClientInstance)inst;
	message.setHeaderValue(clientInstance.getHeaderName(), clientInstance.getCommand());
	instanceContext.setRequiredExtensions();
    }

    void handleHeader (PEPExtensionInstance inst, PEPMessage message) {
    	ClientInstance clientInstance = (ClientInstance)inst;
	String result = message.getHeaderValue(clientInstance.getHeaderName());
	if (result == null)
	    inform("Server didn't respond to "+clientInstance.getCommand());
	else
	    inform("Server responded to \""+clientInstance.getCommand()+"\" with \""+result+"\"");
    }

}

