package w3c.model.www.pep.extensions.escapeBody;

import w3c.model.www.pep.InstanceContext;
import w3c.model.www.pep.altlib.HTTPException;
import w3c.model.www.pep.PEPMessage;
import w3c.model.www.pep.PEPExtension;
import w3c.model.www.pep.PEPExtensionInstance;
import w3c.model.www.pep.bags.*;
import w3c.model.www.pep.altlib.*;

public class Server extends Common {

    public PEPExtensionInstance makeInstance (String headerNames[], int count, InstanceContext instanceContext) {
    	Instance inst = new Instance(headerNames[0], informer); /* this extension only uses one headerName */
	inst.setEscapeChar('s');
	return inst;
    }

    void noElements (InstanceContext instanceContext) {
	ForBag forBag = new ForBag(instanceContext, pepAgent.urlExtensionElements(), this);
	PolicyDecl policyDecl = new PolicyDecl(instanceContext, new IdBag(instanceContext, absoluteURI), forBag);
	policyDecl.setStrength(new StrengthBag(instanceContext, true));
	instanceContext.addPolicyDecl(policyDecl, PEPMessage.C_PEP_INFO);
	if (requiredExtension)
	    instanceContext.setError(HttpErrors.REQUEST_BAD_EXTENSIONS);
    }
}

