package w3c.model.www.pep.extensions.escapeBody;

import w3c.model.www.pep.*;
import java.util.Enumeration;
import w3c.model.www.pep.extensions.escape.Escape;
import w3c.model.www.pep.altlib.*;

abstract public class Common extends Escape {
    final static String prefHeaderName = "EscapeBody-";
/*+
The <A NAME=extensionPort>port</A> for the extensions server is not the same
as for the <A HREF=../../../../tools/basicweb/Server.html:DEFAULT_PORT>Server
default port</A>. If it were, the
<A HREF=../../../../tools/basicweb/Server.html:singleThreaded>single threaded
</A> server could not repsond to the request for the extension classes as it
would still be replying to the request that forced the extension to load.
*/
    protected final static String absoluteURI = "http://localhost:8887/src/classes/escapeBody";

    public Common () {
	super(absoluteURI, prefHeaderName);
    }

    public void initialize (PEPAgent pepAgent, boolean requiredExtension, Informer informer) {
	super.initialize(pepAgent, requiredExtension, informer);
    }

    public PEPExtensionInstance makeInstance (String headerNames[], int count, InstanceContext instanceContext) {
	String headerName = headerNames[0];
	return new Instance(headerName, informer); /* this extension only uses one headerName */
    }

    public boolean map (InstanceContext instanceContext, int when, PEPMessage message, String reason) {
	message.mapURI(reason, "/");
	return true;
    }

    public boolean generateHeaders (InstanceContext instanceContext, int when) throws HTTPException {
	PEPMessage message = instanceContext.getMessage();
	if (when != PEPExtension.CONNECT && when != PEPExtension.HEADERS)
	    return false;
	if (when == PEPExtension.CONNECT && requiredExtension)
	    instanceContext.setRequiredExtensions();
	Instance inst;
	Enumeration key = instanceContext.getExtensionInstances(this);
	while (key.hasMoreElements()) {
	    inst = (Instance)key.nextElement();
	    if (when == PEPExtension.CONNECT)
		message.setHeaderValue(inst.getHeaderName(), ""+inst.getEscapeChar());
	    else
		message.setOutputStream(inst.makeOutputStream(message.getOutputStream()));
	}
	return true;
    }

    abstract void noElements (InstanceContext instanceContext);
/*+
<DT><A NAME=handleHeaders>handleHeaders</A>: <DD>read any headers mapping or alread mapped for this extension.<P>
<A HREF=../../../../tools/basicweb/Message.html#Message.read>Message.read</A> ->
<A HREF=../../PEPAgent.html#PEPAgent.handleHeaders>PEPAgent.handleHeaders</A> -> escapeBody.handleHeaders
*/
    public boolean handleHeaders (InstanceContext instanceContext, int when) throws HTTPException {
	if (when != PEPExtension.HEADERS)
	    return false;
	PEPMessage message = instanceContext.getMessage();
	Enumeration key = instanceContext.getExtensionInstances(this);
	if (!key.hasMoreElements()) {
	    noElements(instanceContext);
	    return true;
	}
	while (key.hasMoreElements()) {
	    Instance inst = (Instance)key.nextElement();
	    message.setInputStream(inst.makeInputStream(message.getInputStream()));
	    String otherSide = message.getHeaderValue(inst.getHeaderName());
	    if (otherSide == null)
		inform("Other side using default escape character \""+inst.getEscapeChar()+"\"");
	    else {
		inform("Other side using escape character \""+otherSide+"\"");
/* Is it cooler to demonstrate separate escape characters or using the passed 
   escape char? Uncomment to use otherside's escape character */
		inst.setEscapeChar(otherSide.charAt(0));
	    }
	}
	return true;
    }

}

