package w3c.model.www.pep.extensions.escapeBody;

import w3c.model.www.pep.*;
import w3c.model.www.pep.bags.*;
import w3c.model.www.pep.altlib.HTTPException;

public class Client extends Common {
/*+
The client always 
*/
    public void makeBag (InstanceContext instanceContext) {
	String name = instanceContext.getPepAgent().nextFreeName(prefHeaderName, this, false);
	String headerNames[] = new String[1];
	headerNames[0] = name;
	ExtDecl extDecl = new ExtDecl(instanceContext,
	    new MapBag(instanceContext, URI, headerNames, 1),
	    new StrengthBag(instanceContext, requiredExtension));
	Instance inst = (Instance)makeInstance(headerNames, 1, instanceContext);
	inst.setEscapeChar(defaultEscapeChar);
	instanceContext.addExtensionInstance(this, inst);

	instanceContext.addExtDecl(extDecl, PEPMessage.C_PEP);
    }

/*+
This will happen when the ignorant client gets a correcting policy declaration. 
Since the client has just parsed this decl and added it to the agent's database,
there will be a rule to call it to handle headers, but no instance of it yet.
*/
    void noElements (InstanceContext instanceContext) {
    }

    public boolean generateHeaders (InstanceContext instanceContext, int when) throws HTTPException {
	if (when == PEPExtension.CONNECT)
	    makeBag(instanceContext);
	return super.generateHeaders (instanceContext, when);
    }

}

