package w3c.model.www.pep.extensions.escape;

import java.io.OutputStream;
import java.io.FilterOutputStream;
import java.io.IOException; 
/*+
See <A HREF=EscapedInputStream>EscapedInputStream</A> for a general description
of the EscapedStream functionality.
*/
public class EscapedOutputStream extends FilterOutputStream {
    EscapeInstance e;

    public EscapedOutputStream (OutputStream out, EscapeInstance e) {
    	super(out);
    	this.e = e;
    }

    public void write (int b) throws java.io.IOException {
    	out.write(b);
	if (isEscape((byte)b))
	    write('$');
    }

    private boolean isEscape (byte b) {
	return e.isEscape((char)b);
    }

    public void write (byte b[]) throws IOException {
	if (b.length == 0)
	    return;
	for (int i = 0; i < b.length; i++)
	    write(b[i]);
	out.write(e.getEscapeChar());
	out.write('.');
    }

    public void write (byte b[], int off, int len) throws IOException {
	for (int i = 0; i < len; i++)
	    write(off + b[i]);
    }

}

