/* accessCounter.Server.java
 * $Id, $Date eric Exp $
 * (c) COPYRIGHT MIT and INRIA, 1997.
 * Please first read the full copyright statement in file COPYRIGHT.html
 *
 * Caution: emits showers of sparks.
 */

package w3c.model.www.pep.extensions.accessCounter;

import java.net.*;
import w3c.model.www.pep.*;
import w3c.model.www.pep.altlib.*;
import w3c.model.www.pep.bags.*;

public class Server extends Common {
    public Server () {super();}

    int getPort(Socket socket) {return socket.getLocalPort();}

    public boolean inCheck (InstanceContext instanceContext, SiteParty site) {
	PEPMessage message = instanceContext.getMessage();
	String URI = message.getURI();

	if (site == null || !site.mapped()) {
	    ForBag forBag = new ForBag(instanceContext, pepAgent.urlExtensionElements(), this);
	    PolicyDecl policyDecl = new PolicyDecl(instanceContext, new IdBag(instanceContext, absoluteURI), forBag);
	    policyDecl.setStrength(new StrengthBag(instanceContext, requiredExtension));
	    instanceContext.addPolicyDecl(policyDecl, PEPMessage.PEP_INFO);
	    if (requiredExtension)
		instanceContext.setError(HttpErrors.REQUEST_BAD_EXTENSIONS);
	    return false;
	}
	return true;
    }

    public boolean outCheck (InstanceContext instanceContext, SiteParty site) {
	PEPMessage message = instanceContext.getMessage();

	if (site == null)
	    return false;
	return true;
    }

}

