package w3c.model.www.pep.extensions.accessCounter;

import java.net.*;
import w3c.model.www.pep.*;
import w3c.model.www.pep.bags.*;
import w3c.model.www.pep.altlib.*;

public class Client extends Common {
    public Client () {super();}

    int getPort(Socket socket) {return socket.getPort();}

    public void makeBag (InstanceContext instanceContext) {
	/* make an extension declaration for AccessCounter */
	String name = instanceContext.getPepAgent().nextFreeName(prefHeaderName, this, false);
/*+
It is less code to do something with parsing, but way more CPU work:<BR>
<CODE>
	ExtDecl extDecl = new ExtDecl("", instanceContext);<BR>
	extDecl.setString("{strength may}{map \""+URI+"\" "+name+"}");<BR>
	extDecl.validate1(); // public access to BasicValue.validate()<BR>
</CODE>
*/
	String headerNames[] = new String[1];
	headerNames[0] = name;
	ExtDecl extDecl = new ExtDecl(instanceContext, 
	    new MapBag(instanceContext, URI, headerNames, 1), 
	    new StrengthBag(instanceContext, requiredExtension));
		
	instanceContext.addExtensionInstance(this, makeInstance(headerNames, 1, instanceContext));
	instanceContext.addExtDecl(extDecl, PEPMessage.PEP);
    }

    public boolean outCheck (InstanceContext instanceContext, SiteParty site) {
	PEPMessage message = instanceContext.getMessage();
/*+
<A NAME=persistentMappings>persistent mappings</A> were considered early in 
PEP's life. Uncommenting
<PRE>
	if (site == null)
</PRE>
will restore this functionality.
*/
	makeBag(instanceContext);
	return true;
    }

    public boolean inCheck (InstanceContext instanceContext, SiteParty site) {
	PEPMessage message = instanceContext.getMessage();
	if (site == null)
	    return false;
	return true;
    }

}

