// StrengthBag.java
// $Id: StrengthBag.java,v 1.2 1997/07/31 13:38:56 eric Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.model.www.pep.bags;

import java.util.*;
import w3c.model.www.pep.*;
import w3c.model.www.pep.altlib.*;

public class StrengthBag extends PEPBag {
    boolean must = false;

    protected void complete () throws HttpParserException {}

    protected final void bufferize (HttpBuffer buf) {
	buf.append((char) '{');
	buf.append("strength ");
	buf.append(must ? "must" : "may");
	buf.append((char) '}');
    }

    public boolean getMust () {return must;}

    protected HttpRawBag lookupSubBag(String name) throws BagNotAllowedException {
	throw new BagNotAllowedException(name, "StrengthBag");
    }

    public void addElement (String name) throws AtomNotAllowedException {
	if ("must".equals(name)) {
	    must = true;
	    return;
	} else if ("may".equals(name))
	    return;
	throw new AtomNotAllowedException(name, "StrengthBag");
    }

    StrengthBag(String name, InstanceContext instanceContext) throws HttpParserException {super(name, instanceContext);}

    public StrengthBag(InstanceContext instanceContext, boolean must) {
	super("strength", instanceContext);
	this.must = must;
    }

}
