// ExtDecl.java
// $Id: PolicyDecl.java,v 1.3 1997/08/02 16:59:05 eric Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.model.www.pep.bags;

import java.util.*;
import w3c.model.www.pep.*;
import w3c.model.www.pep.altlib.*;

public class PolicyDecl extends PEPBag {
    IdBag		id;
    ForBag		fur;
    StrengthBag	strength;
    MaxAgeBag	maxAge;
    ParamsBag	params;

    protected void complete () throws HttpParserException {
	if (id == null)
	    throw new MissingElementException("map or unmap", "PolicyDecl");
	String mappedURLs[];
	if (fur == null) {
	    mappedURLs = new String[1];
	    mappedURLs[0] = instanceContext.getMessage().getURI();
	} else {
	    mappedURLs = new String[fur.getHeaderWildcards().size()];
	    Enumeration en = fur.getHeaderWildcards().elements();
	    for (int i = 0; en.hasMoreElements(); i++)
		mappedURLs[i] = (String)en.nextElement();
	}
	String URI = id.getURI();
	boolean must = strength == null ? false : strength.getMust();
	String hostURI = instanceContext.getMessage().getURI();
	instanceContext.getPepAgent().makeURLExtension(instanceContext.getInformer(), id.getURI(), must, mappedURLs, mappedURLs.length, hostURI);
    }

    protected final void bufferize (HttpBuffer buf) {
	buf.append((byte) '{');
	id.bufferize(buf);
	if (fur != null)
	    fur.bufferize(buf);
	if (strength != null)
	    strength.bufferize(buf);
	if (maxAge != null)
	    maxAge.bufferize(buf);
	if (params != null)
	    params.bufferize(buf);
	buf.append((byte) '}');
    }

    protected HttpRawBag lookupSubBag(String name) throws HttpParserException {
	String className;
	if ("id".equals(name)) {
	    if (id != null)
		throw new NotAllowedException("duplicate id bag", name, "PolicyDecl");
	    return id = new IdBag(name, instanceContext);
	} else if ("for".equals(name)) {
	    if (fur != null)
		throw new NotAllowedException("duplicate for bag", name, "PolicyDecl");
	    return fur = new ForBag(name, instanceContext);
	} else if ("strength".equals(name)) {
	    if (strength != null)
		throw new NotAllowedException("duplicate strength bag", name, "PolicyDecl");
	    return strength = new StrengthBag(name, instanceContext);
	} else if ("max-age".equals(name)) {
	    if (maxAge != null)
		throw new NotAllowedException("duplicate max-age bag", name, "PolicyDecl");
	    return maxAge = new MaxAgeBag(name, instanceContext);
	} else if ("params".equals(name)) {
	    if (params != null)
		throw new NotAllowedException("duplicate strength params", name, "PolicyDecl");
	    return params = new ParamsBag(name, instanceContext);
	}
	return null;
    }

    public void validate1() {super.validate();} /* public access to BasicValue.validate() */
    public void addElement (String name) throws AtomNotAllowedException {
	throw new AtomNotAllowedException(name, "PolicyDecl");
    }

    public IdBag getId() {return id;}
    public void setFor(ForBag fur) {this.fur = fur;}
    public ForBag getFor() {return fur;}
    public void setStrength(StrengthBag strength) {this.strength = strength;}
    public StrengthBag getStrength() {return strength;}
    public void setMaxAge(MaxAgeBag maxAge) {this.maxAge = maxAge;}
    public MaxAgeBag getMaxAge() {return maxAge;}

    public PolicyDecl(String name, InstanceContext instanceContext) throws HttpParserException {
	super(name, instanceContext);
    }

    public PolicyDecl (InstanceContext instanceContext, IdBag idBag) {
	super("", instanceContext);
	this.id = idBag;
    }

    public PolicyDecl (InstanceContext instanceContext, IdBag idBag, ForBag forBag) {
	super("", instanceContext);
	this.id = idBag;
	this.fur = forBag;
    }

}
