// PEPLineBag.java
// $Id: PEPLineBag.java,v 1.2 1997/07/31 13:38:54 eric Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.model.www.pep.bags;

import java.util.*;
import w3c.model.www.pep.*;
import w3c.model.www.pep.altlib.*;

public class PEPLineBag extends PEPBag {

    Vector extDecls = new Vector(1, 1);

    public final void updateByteValue () {
	HttpBuffer buf = new HttpBuffer();
	bufferize(buf);
	raw = buf.getByteCopy();
	roff = 0;
	rlen = raw.length;
    }

    protected final void bufferize (HttpBuffer buf) {
	boolean first = true;
	Enumeration key = keys();
	ExtDecl temp = null;
	while (key.hasMoreElements()) {
	    temp = (ExtDecl) key.nextElement();
	    if (first)
		first = false;
	    else
		buf.append((char) ',');
	    temp.bufferize(buf);
	}
    }

    protected void complete () throws HttpParserException {
	if (extDecls.size() < 1)
	    throw new HttpParserException("PEPLineBag needs at least one element");
    }

    public PEPLineBag (InstanceContext instanceContext)
	throws HTTPException
    {super("", instanceContext);}

    protected HttpRawBag lookupSubBag(String name) throws HttpParserException {
	if (!"".equals(name))
	    throw new NotAllowedException("named bag", name, "PEPLineBag");
	ExtDecl extDecl = new ExtDecl(name, instanceContext);
	extDecls.addElement(extDecl);
	return extDecl;
    }

    public void addElement(String name) throws NotAllowedException {
	throw new AtomNotAllowedException(name, "PEPLineBag");
    }

    public void addExtDecl(ExtDecl extDecl) throws HttpParserException {
	if (!"".equals(extDecl.getName()))
	    throw new NotAllowedException("named bag", extDecl.getName(), "PEPLineBag");
	extDecls.addElement(extDecl);
    }

    public Enumeration keys () {return extDecls.elements();}

}

