// PEPLineBag.java
// $Id: PEPInfoLineBag.java,v 1.2 1997/07/31 13:38:54 eric Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.model.www.pep.bags;

import java.util.*;
import w3c.model.www.pep.*;
import w3c.model.www.pep.altlib.*;

public class PEPInfoLineBag extends PEPBag {

    Vector policyDecls = new Vector(1, 1);

    public final void updateByteValue () {
	HttpBuffer buf = new HttpBuffer();
	bufferize(buf);
	raw = buf.getByteCopy();
	roff = 0;
	rlen = raw.length;
    }

    protected final void bufferize (HttpBuffer buf) {
	boolean first = true;
	Enumeration key = keys();
	PolicyDecl temp = null;
	while (key.hasMoreElements()) {
	    temp = (PolicyDecl) key.nextElement();
	    if (first)
		first = false;
	    else
		buf.append((char) ',');
	    temp.bufferize(buf);
	}
    }

    protected void complete () throws HttpParserException {
	if (policyDecls.size() < 1)
	    throw new HttpParserException("PEPInfoLineBag needs at least one element");
    }

    public PEPInfoLineBag (InstanceContext instanceContext)
//		throws HTTPException
    {super("", instanceContext);}

    protected HttpRawBag lookupSubBag(String name) throws HttpParserException {
	if (!"".equals(name))
	    throw new NotAllowedException("named bag", name, "PEPInfoLineBag");
	PolicyDecl policyDecl = new PolicyDecl(name, instanceContext);
	policyDecls.addElement(policyDecl);
	return policyDecl;
    }

    public void addElement(String name) throws NotAllowedException {
	throw new AtomNotAllowedException(name, "PEPInfoLineBag");
    }

    public void addPolicyDecl(PolicyDecl policyDecl) throws HttpParserException {
	if (!"".equals(policyDecl.getName()))
	    throw new NotAllowedException("named bag", policyDecl.getName(), "PEPInfoLineBag");
	policyDecls.addElement(policyDecl);
    }

    public Enumeration keys () {return policyDecls.elements();}

}

