// MapBag.java
// $Id: MaxAgeBag.java,v 1.2 1997/07/31 13:38:52 eric Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.model.www.pep.bags;

import java.util.*;
import w3c.model.www.pep.*;
import w3c.model.www.pep.altlib.*;

public class MaxAgeBag extends PEPBag {
    long expire;

    protected void complete () throws HttpParserException {
	if (expire <= System.currentTimeMillis())
	    throw new NotAllowedException("pre-expired max-age", Long.toString(expire), "MaxAgeBag");
    }

    protected final void bufferize (HttpBuffer buf) {
	buf.append("{max-age ");
	buf.append(Long.toString(expire));
	buf.append((char) '}');
    }

    public long getExpire () {return expire;}

    protected HttpRawBag lookupSubBag (String name) throws BagNotAllowedException {
	throw new BagNotAllowedException(name, "MaxAgeBag");
    }

    public void addElement (String name) throws NotAllowedException {
	try {
	    expire = Long.parseLong(name, 10);
	} catch (NumberFormatException e) {
	    throw new NotAllowedException("max-age", name, "MaxAgeBag");
	}
	expire =+ System.currentTimeMillis();
    }

    MaxAgeBag(String name, InstanceContext instanceContext) throws HttpParserException {
	super(name, instanceContext);
    }

    public MaxAgeBag (InstanceContext instanceContext, long expire) {
	super("max-age", instanceContext);
	this.expire = expire;
    }

}

