// MapBag.java
// $Id: IdBag.java,v 1.2 1997/07/31 13:38:51 eric Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.model.www.pep.bags;

import java.util.*;
import w3c.model.www.pep.*;
import w3c.model.www.pep.altlib.*;

public class IdBag extends PEPBag {
    String URI = null;

    protected void complete () throws HttpParserException {
	if (URI == null)
	    throw new MissingElementException("URI", "IdBag");
    }

    protected final void bufferize (HttpBuffer buf) {
	buf.append("{id \"");
	buf.append(URI);
	buf.append((byte)'\"');
	buf.append((char) '}');
    }

    public String getURI () {return URI;}

    protected HttpRawBag lookupSubBag (String name) throws BagNotAllowedException {
	throw new BagNotAllowedException(name, "IdBag");
    }

    public void addElement (String name) throws NotAllowedException {
	if (URI != null)
	    throw new NotAllowedException("duplicate URI", name, "IdBag");
	if (name.indexOf('"') != 0 || name.lastIndexOf('"') != name.length()-1)
	    throw new NotAllowedException("unquoted URI", name, "MapBag");
	URI = name.substring(1, name.length()-1);
    }

    IdBag(String name, InstanceContext instanceContext) throws HttpParserException {
	super(name, instanceContext);
    }

    public IdBag (InstanceContext instanceContext, String URI) {
	super("id", instanceContext);
	this.URI = URI;
    }

}

