// ExtDecl.java
// $Id: ExtDecl.java,v 1.2 1997/07/31 13:38:50 eric Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.model.www.pep.bags;

import java.util.*;
import w3c.model.www.pep.*;
import w3c.model.www.pep.altlib.*;

public class ExtDecl extends PEPBag {
    MapBag		map;
    UnmapBag	unmap;
    StrengthBag	strength;
    ParamsBag	params;

    protected void complete () throws HttpParserException {
	if (map == null && unmap == null)
	    throw new MissingElementException("map or unmap", "ExtDecl");
	if (map == null)
	    return;
	String URI = map.getURI();
	boolean must = false;
	if (strength != null && strength.getMust() == true)
	    must = true;
	Vector headerWildcards = map.getHeaderWildcards();
	int headerNameCount = headerWildcards.size();
	String headerNames[] = new String[headerNameCount];
	headerWildcards.copyInto(headerNames);
	instanceContext.getPepAgent().makeInstance(URI, must, headerNames, headerNameCount, instanceContext, 999);
    }

    protected final void bufferize (HttpBuffer buf) {
	buf.append((byte) '{');
	if (map == null)
	    unmap.bufferize(buf);
	else
	    map.bufferize(buf);
	if (strength != null)
	    strength.bufferize(buf);
	if (params != null)
	    params.bufferize(buf);
	buf.append((byte) '}');
    }

    protected HttpRawBag lookupSubBag(String name) throws HttpParserException {
	String className;
	if ("map".equals(name)) {
	    if (map != null || unmap != null)
		throw new NotAllowedException("duplicate map or unmap bag", name, "ExtDecl");
	    return map = new MapBag(name, instanceContext);
	} else if ("unmap".equals(name)) {
	    if (map != null || unmap != null)
		throw new NotAllowedException("duplicate map or unmap bag", name, "ExtDecl");
	    if (strength != null)
		throw new NotAllowedException("strength", name, "ExtDecl");
	    return unmap = new UnmapBag(name, instanceContext);
	} else if ("strength".equals(name)) {
	    if (strength != null)
		throw new NotAllowedException("duplicate strength bag", name, "ExtDecl");
	    if (unmap != null)
		throw new NotAllowedException("unmap", name, "ExtDecl");
	    return strength = new StrengthBag(name, instanceContext);
	} else if ("params".equals(name)) {
	    if (params != null)
		throw new NotAllowedException("duplicate strength params", name, "ExtDecl");
	    return params = new ParamsBag(name, instanceContext);
	}
	return null;
    }

    public void validate1() {super.validate();} /* public access to BasicValue.validate() */
    public void addElement (String name) throws AtomNotAllowedException {
	throw new AtomNotAllowedException(name, "ExtDecl");
    }

    public MapBag getMap() {return map;}
    public StrengthBag getStrength() {return strength;}

    public ExtDecl(String name, InstanceContext instanceContext) throws HttpParserException {
	super(name, instanceContext);
    }

    public ExtDecl (InstanceContext instanceContext, MapBag mapBag) {
	super("", instanceContext);
	this.map = mapBag;
    }

    public ExtDecl (InstanceContext instanceContext, MapBag mapBag, StrengthBag strengthBag) {
	super("", instanceContext);
	this.map = mapBag;
	this.strength = strengthBag;
    }

    public ExtDecl (InstanceContext instanceContext, MapBag mapBag, StrengthBag strengthBag, ParamsBag params) {
	super("", instanceContext);
	this.map = mapBag;
	this.strength = strengthBag;
	this.params = params;
    }

    public ExtDecl (InstanceContext instanceContext, UnmapBag unmapBag) {
	super("", instanceContext);
	this.unmap = unmapBag;
    }

}
