package w3c.model.www.pep.altlib;

import java.util.*;

public class WildCardElement {
    String text;
    boolean wild;
    Object object;

    WildCardElement (String text, boolean wild, Object object) {
	this.text = text;
	this.wild = wild;
	this.object = object;
    }

    public Object getObject () {
	return object;
    }

    public boolean equals (String text, boolean wild) {
	return wild == this.wild && text.equals(this.text);
    }

    public boolean sameObject (Object compTo) {
	return object == compTo;
    }

    public String toString () {
	StringBuffer buf = new StringBuffer();
	buf.append('\"');
	buf.append(text);
	buf.append('\"');
	if (wild)
	    buf.append(" *");
	return new String(buf.toString());
    }

    int compareTo (String that, boolean thatIsWild) {
	int thisLen = text.length();
	int thatLen = that.length();
	boolean thisIsWild = wild; /* just for clarity */

	/* thisLen > thatLen: checkIsWild ? thatLen : thisLen
	 * thatLen > thisLen: localIsWild ? thisLen : thatLen
	 *
	 * case: thisLen: "Protocol*" thatLen: "Protocols*"
	 * thisLen !> thatLen:  thisIsWild: thisLen (8) - "Protocol".compareTo("Protocol")
	 *
	 * case: thisLen: "Protocol" thatLen: "Protocols*"
	 * thisLen !> thatLen: !thisIsWild: thatLen (9) - "Protocol".compareTo("Protocols")
	 *
	 * case: thisLen: "Protocol*" thatLen: "Protocols"
	 * thisLen !> thatLen: !thisIsWild: thatLen (8) - "Protocol".compareTo("Protocol")
	 *
	 * case: thisLen: "Protocols" thatLen: "Protocol*"
	 * thisLen  > thatLen: thatIsWild: thatLen (8) - "Protocol".compareTo("Protocol")
	 */
	int compareLength = thisLen > thatLen ?
	       thatIsWild ? thatLen : thisLen :
	       thisIsWild ? thisLen : thatLen ;

	String thisComp = compareLength > thisLen ?
	    text : text.substring(0, compareLength);
	String thatComp = compareLength > thatLen ?
	    that : that.substring(0, compareLength);
	return thisComp.compareTo(thatComp);
    }

}

