package w3c.model.www.pep.altlib;

public class ErrorContext implements HttpErrors {
    int error = REQUEST_OK;
    Informer informer;

    public ErrorContext (Informer informer) {
	this.informer = informer;
    }

    public Informer getInformer () {
	return informer;
    }

    public void clear () {
	error = REQUEST_OK;
    }

    public void setError (int error) {
    	this.error = error;
    }

    public boolean promoteError (int error) {
	if (this.error != REQUEST_OK || this.error == error)
	    return false;
	this.error = error;
	return true;
    }
    public int getError () {
	return error;
    }

public void inform (String message) {informer.inform(message);}
public void inform (String message, String text) {informer.inform(message, text);}

}

