/* copyright 1997 World Wide Web Consortium
 * by Eric Prud'hommeaux
 *
 * Thanks for the memory errors...
 */

package w3c.model.www.pep;

import java.util.*;

public class UniqueNameList {
    Hashtable usedList;
    Random random;

    public UniqueNameList (int initialCapacity) {
	usedList = new Hashtable(initialCapacity);
	random = new Random();
    }

/*+
<P>
I added the extension here to be able to lookup the names used by an extension. 
It may also be usefull to split the nameList into a Hashtable of nameLists. I 
haven't found a compelling reason to use extensions as PEPExtensions. It may be 
usefull to make them be objects and make this not be PEP specific.
</P><P>
This does not yet handle wild or do clever negotiation with requesting extension
</P>
*/
    public String nextFreeName (String initialName, PEPExtension extension, boolean wild) {
	String name = initialName;
	while (usedList.get(name) != null) {
	    name = initialName + random.nextInt();
	}
	usedList.put(name, extension);
	return name;
    }

}

