package w3c.model.www.pep;

import java.util.Vector;
import java.util.Enumeration;
import w3c.model.www.pep.altlib.*;

/* PEPExtensionSet contains a PEP extension and its instances
 *
 * @@@ to be added: mechanism for PEP to hold references to extensions
 * that couldn't be resolved at the time of addition
 */
class PEPExtensionSet {
    PEPExtension extension;
    Vector instances;

    PEPExtensionSet (PEPExtension extension) {
	this.extension = extension;
	instances = new Vector(1, 1);
    }

    PEPExtension getExtension () {
	return extension;
    }

    void addInstance (PEPExtensionInstance instance) {
	instances.addElement(instance);
    }

    void removeInstanceAt (int i) {
	instances.removeElementAt(i);
    }

    void removeInstance (PEPExtensionInstance instance) {
	instances.removeElement(instance);
    }

    void removeAllInstances () {
	instances.removeAllElements();
    }

    Enumeration instances () {
	return instances.elements();
    }

}

