package w3c.model.www.pep;

import w3c.model.www.pep.altlib.Informer;

abstract public class PEPExtensionInstance {
    String headerName;
    protected Informer informer;

    protected PEPExtensionInstance (String headerName, Informer informer) {
	this.headerName = headerName;
	this.informer = informer;
    }

    public String getHeaderName () {
	return headerName;
    }

/*+
Extensions that use their instances for extra-transaction persistence (eg 
<A HREF=extensions/accessCounter/Common.html#Common.makeInstance>accessCounter</A>
may update the header (essentiallly replacing PEPExtensionInstance portion of the 
previous instance).
*/
    public void setHeaderName (String headerName) {
	this.headerName = headerName;
    }

}

