/* InstanceContext.java
 * $Id, $Date eric Exp $
 * (c) COPYRIGHT MIT and INRIA, 1997.
 * Please first read the full copyright statement in file COPYRIGHT.html
 *
 * To my many comrades in code who's
 * lives were lost to computers.
 */

package w3c.model.www.pep;

import w3c.model.www.pep.bags.*;
import w3c.model.www.pep.altlib.*;
import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;

public class InstanceContext {
    PEPMessage message;
    PEPAgent pepAgent;
    PEPLineBag pepLineBag;
    PEPInfoLineBag pepInfoLineBag;
    PEPLineBag c_pepLineBag;
    PEPInfoLineBag c_pepInfoLineBag;
    String reason;
    ErrorContext errorContext;
    Vector extensions;
    Hashtable instances;

/*+
<H2>Construction</H2>
*/
    public InstanceContext (PEPAgent pepAgent, PEPMessage message, ErrorContext errorContext) {
	this.pepAgent = pepAgent;
	this.message = message;
	this.errorContext = errorContext;
	pepLineBag = null;
	pepInfoLineBag = null;
	c_pepLineBag = null;
	c_pepInfoLineBag = null;
	extensions = new Vector();
	instances = new Hashtable();
    }

    public InstanceContext (InstanceContext old, PEPMessage message) {
	this.pepAgent = old.pepAgent;
	this.message = message;
	this.errorContext = old.errorContext;
	pepLineBag = old.pepLineBag;
	pepInfoLineBag = old.pepInfoLineBag;
	c_pepLineBag = old.c_pepLineBag;
	c_pepInfoLineBag = old.c_pepInfoLineBag;
	extensions = old.extensions;
	instances = old.instances;
    }

/*+
<H2>Simple Access</H2>
*/
    public PEPAgent getPepAgent () {return pepAgent;}
    public PEPMessage getMessage () {return message;}
    public void setError (int error) {errorContext.promoteError(error);}

/*+
<H2>PEP line</H2>
*/
    public void addExtDecl (ExtDecl extDecl, int whichOne) {
	try {
	    if (whichOne == PEPMessage.PEP) {
		if (pepLineBag == null)
		    pepLineBag = new PEPLineBag(this);
		pepLineBag.addExtDecl(extDecl);
	    } else {
		if (c_pepLineBag == null)
		    c_pepLineBag = new PEPLineBag(this);
		c_pepLineBag.addExtDecl(extDecl);
	    }
	} catch (HTTPException e) {}
    }
    public String getPEPLine () {return pepLineBag == null ? null : pepLineBag.toExternalForm();}

/*+
<H2>PEP-Info line</H2>
*/
    public void addPolicyDecl (PolicyDecl policyDecl, int whichOne) {
	try {
	    if (whichOne == PEPMessage.PEP_INFO) {
		if (pepInfoLineBag == null)
		    pepInfoLineBag = new PEPInfoLineBag(this);
		pepInfoLineBag.addPolicyDecl(policyDecl);
	    } else {
		if (c_pepInfoLineBag == null)
		    c_pepInfoLineBag = new PEPInfoLineBag(this);
		c_pepInfoLineBag.addPolicyDecl(policyDecl);
	    }
	} catch (HttpParserException e) {}
    }
    public String getPEPInfoLine () {return pepInfoLineBag.toExternalForm();}

    public Hashtable mayIGetYouBags () {
	Hashtable ret = new Hashtable();
	if (c_pepLineBag != null)	ret.put(new Integer(PEPMessage.C_PEP), c_pepLineBag.toExternalForm());
	if (c_pepInfoLineBag != null)	ret.put(new Integer(PEPMessage.C_PEP_INFO), c_pepInfoLineBag.toExternalForm());
	if (pepLineBag != null)	ret.put(new Integer(PEPMessage.PEP), pepLineBag.toExternalForm());
	if (pepInfoLineBag != null)	ret.put(new Integer(PEPMessage.PEP_INFO), pepInfoLineBag.toExternalForm());
	return ret;
    }

/*+
<H2>Reasons</H2>
The <A HREF=PEPAgent.html>PEPAgent</A> sets the reason that an extension was 
called so the extension can use it for mapping. So far this is just a URI.
*/
    public void setReason (String reason) {this.reason = reason;}
    public String getReason () {return reason;}

/*+
<H2>Extensions</H2>
Add an extension to the list of extensions being dispatched for a message. 
Because the reply gets the same InstanceContext as the request, the extensions 
are used through the whole transaction.
*/
    public void addExtension (PEPExtension extension) {
/*+
This is sort of a cheat for the client side. Ideally I would never try to add 
an extension during handleHeaders that was already added on generateHeaders, 
but it was difficult to sepperate the necessary mapping from the redundant 
extension addition in PEPAgent.map. The problem is that we want the extension 
to be able to register itself immediately, either through 
<A HREF=PEPAgent.html#PEPAgent.map>mapping</A>, or through
<A HREF=PEPAgent.html#PEPAgent.makeInstance>makeInstance</A>.
*/
    	if (!extensions.contains(extension))
	    extensions.addElement(extension);
    }

    public Enumeration getExtensions () {
	return extensions.elements();
    }

/*+
<A NAME=RequiredExtensions>RequiredExtensions</A> - tell the agent to use 
PEP-GET or PUT. This must be done by connect time when the request get's sent.
*/
    boolean required = false;
    public void setRequiredExtensions () {
    	required = true;
    }

    public boolean hasRequiredExtensions () {
    	return required;
    }

/*+
<H2>Extension instances</H2>
*/
    private Vector getInstances (PEPExtension extension) {
    	Vector v = (Vector)instances.get(extension);
    	if (v == null) {
    	    v = new Vector();
    	    instances.put(extension, v);
    	}
    	return v;
    }

    public void addExtensionInstance (PEPExtension extension, PEPExtensionInstance instance) {
	getInstances(extension).addElement(instance);
    }

    public Enumeration getExtensionInstances (PEPExtension extension) {
	return getInstances(extension).elements();
    }

    public Informer getInformer () {return errorContext.getInformer();}

    public void inform (String message) {errorContext.inform(message);}
    public void inform (String message, String text) {errorContext.inform(message, text);}

}
