package w3c.model.tools.basicweb;

import java.io.*;
import java.net.*;
import w3c.model.www.pep.PEPAgent;
import w3c.model.www.pep.PEPClient;
import w3c.model.www.pep.altlib.Informer;
import w3c.model.www.pep.altlib.ErrorContext;

class ProxyRequest extends Request
{
    URL origUrl;
    PEPClient pepClient;

/*- proxies generated by a <A HREF=BaseClient.html#doIt>client</A> */
    ProxyRequest(Socket socket, InputStream in, OutputStream out, Method method, URL url, PEPAgent pepAgent, ErrorContext errorContext) {
	super(socket, in, out, method, url, pepAgent, errorContext); /* user of proxy */
    }

/*- proxies generated by a <A HREF=ProxyServer.html#makeRequest>server</A>. The 
PEPClient is passed to the CopyBodyProxy method. */
    ProxyRequest(Socket socket, InputStream in, OutputStream out, PEPAgent pepAgent, ErrorContext errorContext, PEPClient pepClient) {
	super(socket, in, out, pepAgent, errorContext); /* used by proxy */
	this.pepClient = pepClient;
    }

    URL getOrigUrl () {return origUrl;}

    boolean parseStartLine() {
	if (!super.parseStartLine())
	    return false;
	try {
	    origUrl = new URL(URI);
	} catch (MalformedURLException e) {
	    return false;
	}
	URI = origUrl.getFile();
	return true;
    }

    void makeRequestLine(int methodNumber, URL url, String httpVersion) {
    	String requestURI = url == null ? URI : url.toExternalForm();
	this.methodNumber = methodNumber;
	this.URI = URI;
	this.httpVersion = httpVersion;
	startLine = methods[methodNumber] + " " + requestURI + " " + "HTTP/" + httpVersion;
    }

    MethodServer lookupMethod (int methodNumber) {
	switch (methodNumber) {
	    case GET:
	    case PEP_GET:
	    case PUT:
	    case PEP_PUT:
		return new ProxyClient(pepClient, methods[methodNumber], new Informer("<Pclint>", ": "));
	    default:
		errorContext.promoteError(REQUEST_NOT_IMPLEMENTED);
		return null;
	}
    }

}


