package w3c.model.tools.basicweb;

import w3c.model.www.pep.PEPAgent;
import w3c.model.www.pep.PEPClient;
import w3c.model.www.pep.altlib.Informer;
import w3c.model.www.pep.altlib.ErrorContext;
import w3c.model.www.pep.altlib.HttpErrors;
import w3c.model.www.pep.altlib.HTTPException;
import w3c.model.www.pep.altlib.HttpParserException;
import java.io.*;
import java.net.*;

class ProxyClient extends BaseClient implements MethodClient, MethodServer {
    PEPClient pepClient;

    String requestedMethod = "";

    ProxyClient (PEPClient pepClient, String requestedMethod, Informer informer) {
    	super(pepClient, informer);
    	prepPEP();
	this.pepClient = pepClient;
	this.requestedMethod = requestedMethod;
    }

    public String methodStr () {
	return requestedMethod;
    }

    public boolean initialize (Request request) {
	return true;
    }

    ProxyRequest clientRequest;
    Reply clientReply;

    public void serve (Request request1, Reply reply1) throws IOException {
    	/* the 1's avoid unobserved name collisions */
    	clientRequest = (ProxyRequest)request1;
    	clientReply = reply1;
	MethodClient method = this;
	URL url = clientRequest.getOrigUrl();
	doIt(method, url, url.getHost(), url.getPort());
    }

    Request makeRequest (Socket socket, InputStream in, OutputStream out, Method method, URL url, PEPAgent pepAgent, ErrorContext errorContext) {
	return new Request(socket, null, out, method, url, pepAgent, errorContext);
    }

    void prepPEP () {
	/*- create and initialize required <A NAME=makeEscapeBody>EscapeBody</A> */
	w3c.model.www.pep.extensions.escapeBody.Client escapeProxy = new w3c.model.www.pep.extensions.escapeBody.Client();
	escapeProxy.initialize(pepAgent, true, informer);
	pepAgent.addUrlExtension(escapeProxy, "/escaped/*");
    }

    OutputStream makeReplyOutputStream () {
	return null;
    }

    public void write (Message message) throws IOException {
    	clientRequest.clearHeader(Message.C_PEP_INFO);
    	clientRequest.clearHeader(Message.C_PEP);
    	message.useHeaders(clientRequest);
//	inform("------------- Server ---------------");
    	message.writeHeaders();
    	clientRequest.setOut(message.getOut());
    	clientRequest.readRest();
    }

    public void read (Message message) throws IOException {
    	Reply serverReply = (Reply)message;
	serverReply.read();
	if (pepAgent.getRedo()) {
/*+
<H3><A NAME=Retry>Retry</A></H3>
If Server complained about missing C-PEP and we fixed them, need to resubmit.
One improvement would be to pass the error without retry if the server also
complained about missing PEP extensions.
*/
	    message.setOut(null);
	    message.readRest();	// get it out of the pipe
	    return;
	}
    	message.clearHeader(Message.C_PEP_INFO);
    	message.clearHeader(Message.C_PEP);
    	clientReply.useHeaders(message);
	clientReply.copyStatusLine(serverReply);
//	inform("------------- Client ---------------");
    	clientReply.writeHeaders();
        message.setOut(clientReply.getOut());
    	message.readRest();
    }

}

