package w3c.model.tools.basicweb;

import java.io.File;
import java.io.IOException;

class GETServer extends GET implements MethodServer {
    public String methodStr () {return "GET";}

    public boolean initialize (Request request) {return true;}

    public void serve (Request request, Reply reply) throws IOException {
	/* check out the URI */
	File file = new File(request.getPath());
	if (!file.exists()) {
//	    inform("Couldn't find \"" + file.getAbsolutePath() + "\"");
	    reply.prefab(Reply.REQUEST_NOT_FOUND, Reply.BUMMER);
	    return;
	}
	reply.setMediaTypeFor(request.getURI());

	/* dish it out */
	reply.makeStatusLine(Reply.REQUEST_OK);
	reply.getFile(file);
    }

}

