/* basicweb.Client.java
 * $Id, $Date eric Exp $
 * (c) COPYRIGHT MIT and INRIA, 1997.
 * Please first read the full copyright statement in file COPYRIGHT.html
 *
 * Please help anthropomorphised code
 * maintain its self-respect.
 */

/*+
The <em>basic client</em> generates http  <a href="Request.html">requests</a> 
from command line arguments and sends them to a <a href="Server.html">server</a>. 
The <a href="Reply.html">reply</a> is thrown away.</p>
*/
package w3c.model.tools.basicweb;

import java.io.*;
import java.net.*;
import w3c.model.www.pep.PEPAgent;
import w3c.model.www.pep.PEPClient;
import w3c.model.www.pep.bags.*;
import w3c.model.www.pep.altlib.*;
import java.util.Vector;
import java.util.Enumeration;

public class Client extends BaseClient {
    private final static boolean downloadableExtensions = true;

    Client (Informer informer) {
	super(informer);
    }

    w3c.model.www.pep.extensions.remoteControl.Client remoconClient = null;
    Vector pendingRemoconCommands = null;
    void addRemoCon (String cmd) {
    	if (pendingRemoconCommands == null)
    	    pendingRemoconCommands = new Vector();
	pendingRemoconCommands.addElement(cmd);
    }


    String proxyHost = null;
    int proxyPort = 0;
    Request makeRequest (Socket socket, InputStream in, OutputStream out, Method method, URL url, PEPAgent pepAgent, ErrorContext errorContext) {
    	Request ret;
	if (proxyHost == null)
	    ret = new Request(socket, null, out, method, url, pepAgent, errorContext);
	else
	    ret = new ProxyRequest(socket, null, out, method, url, pepAgent, errorContext);
	if (pendingRemoconCommands != null) {
	    Enumeration e = pendingRemoconCommands.elements();
	    while (e.hasMoreElements())
		remoconClient.makeInstance(ret.getInstanceContext(), (String)e.nextElement());
	}
	return ret;
    }

    void prepPEP () throws HttpParserException, HTTPException {
	pepAgent = new PEPClient();
	if (!downloadableExtensions) {
	    /*- create and initialize <A NAME=makeAccessCounter>AccessCounter</A> */
	    w3c.model.www.pep.extensions.accessCounter.Client accCounterClient = new w3c.model.www.pep.extensions.accessCounter.Client();
	    accCounterClient.initialize(pepAgent, true, informer);
//	    pepAgent.addUrlExtension(accCounterClient, "http://localhost:8888/countable/*");
//	    pepAgent.addAlwaysExtension(accCounterClient);
	    w3c.model.www.pep.extensions.escapeBody.Client escapeClient = new w3c.model.www.pep.extensions.escapeBody.Client();
	    escapeClient.initialize(pepAgent, true, informer);
	}
	remoconClient = new w3c.model.www.pep.extensions.remoteControl.Client(this, pepAgent);
	remoconClient.initialize(pepAgent, true, informer);
    }

    OutputStream makeReplyOutputStream () {
	return new NullOutputStream(informer);     // could also go to a file
    }

    void doIt (MethodClient method, URL url) {
	if (pendingRemoconCommands != null)
	    pepAgent.addAlwaysExtension(remoconClient);
	String host = proxyHost;
	int port = proxyPort;
	if (proxyHost == null) {
	    host = url.getHost();
	    port = url.getPort();
	}
	super.doIt(method, url, host, port);
	if (pendingRemoconCommands != null) {
	    pepAgent.removeAlwaysExtension(remoconClient);
	    pendingRemoconCommands = null;
	}
    }

    public static void main (String args[]) throws MalformedURLException {
	if (args.length == 0) {
	    System.err.println("Usage: [-get] URL [URL ...] | -put URL file | -proxy IP port");
	    System.err.println("for example: -get http://localhost:8888/Overview.html");
	    return;
	}
	Client client = new Client(new Informer("<Client>", ": "));
	for (int i = 0 ; i < args.length ; i++) {
	    if (args[i].equals ("-put")) {
		File localFile = new File(args[++i]);
		client.doIt(new PUTClient(localFile), new URL(args[++i]));
	    } else if (args[i].equals ("-get")) {
		client.doIt(new GETClient(), new URL(args[++i]));
	    } else if (args[i].equals ("-proxy")) {
		client.proxyHost = args[++i];
		if ("".equals(client.proxyHost))
		    client.proxyHost = null;
		else
		    client.proxyPort = Integer.parseInt(args[++i]);
	    } else if (args[i].equals ("-remocon")) {
		client.addRemoCon(args[++i]);
	    } else {
		client.doIt(new GETClient(), new URL(args[i]));
	    }
	}
    }
}

