/* basicweb.Agent.java
 * $Id, $Date eric Exp $
 * (c) COPYRIGHT MIT and INRIA, 1997.
 * Please first read the full copyright statement in file COPYRIGHT.html
 *
 * Do not taunt super-happy-fun-code.
 */

/*+
A <em>web agent</em> is any program that takes part in some part of an http <a
href="Request.html">request</a>/<a href="Reply.html">reply</a> conversation.
Basicweb agents include:</p>
<ul>
<li>
<a href="Client.html">Client</a> - A simple program that recieves request
instructions from its command line arguments. 
<li>
<a href="Server.html">Server</a> - Listens for connections on a given port and
serves simple HTTP requests like GET and PUT. 
<li>
<a href="ProxyServer.html">ProxyServer</a> - Listens for connections like a server does,
but uses <a href="ProxyClient.html">ProxyClient</a> to refer them to another server to be answered. 
</ul>
*/
package w3c.model.tools.basicweb;

//import w3c.model.www.pep.PEPAgent;
//import w3c.model.www.pep.altlib.ErrorContext;
import w3c.model.www.pep.PEPAgent;
import w3c.model.www.pep.PEPServer;
import w3c.model.www.pep.altlib.*;

abstract class Agent {
    PEPAgent pepAgent;
    Informer informer;
    ErrorContext errorContext;

    Agent (Informer informer) {
	construct(informer);
	try {
	    prepPEP();
	} catch (HttpParserException p) {
	    System.err.println("Error setting up PEPClient");
	    System.err.println(p);
	    p.printStackTrace();
//	    throw p;
	} catch (HTTPException e) {
	    System.err.println("Error setting up PEPClient");
	    System.err.println(e);
	    e.printStackTrace();
//	    throw e;
	}
    }

    Agent (PEPAgent pepAgent, Informer informer) {
	construct(informer);
	this.pepAgent = pepAgent;
    }

    private void construct (Informer informer) {
    	this.informer = informer;
	errorContext = new ErrorContext(informer);
    }

    abstract void prepPEP () throws HttpParserException, HTTPException;

    public void inform (String message) {
	informer.inform(message);
    }

    public void inform (String message, String text) {
	informer.inform(message, text);
    }

}

