<xsl:stylesheet xmlns:its="http://www.w3.org/2005/11/its" xmlns:datc="http://example.com/datacats"
	xmlns:itsx="http://www.w3.org/2008/12/its-extensions"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:XSL="http://www.w3.org/1999/XSL/TransformAlias" exclude-result-prefixes="xsl datc"
	xmlns:xlink="http://www.w3.org/1999/xlink" version="1.0">
	<xsl:output method="xml" indent="yes" encoding="utf-8"/>
	<xsl:strip-space elements="*"/>
	<xsl:namespace-alias stylesheet-prefix="XSL" result-prefix="xsl"/>
	<xsl:param name="inputfile"/>
	<xsl:param name="datacat"/>
	<xsl:param name="rulesElement"
		select="document('sampleCatDesc.xml')//datc:datacat[@name=$datacat]/datc:rulesElement/@name"/>
	<xsl:template match="/">
		<!-- Write general stylesheet stuff -->
		<XSL:stylesheet version="1.0" xmlns:its="http://www.w3.org/2005/11/its" 	xmlns:itsx="http://www.w3.org/2008/12/its-extensions"
			xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
			<XSL:output method="xml" indent="yes" encoding="utf-8"/>
			<xsl:for-each select="//datc:datacat[@name=$datacat]">
				<XSL:template match="/">
					<XSL:apply-templates select="node() | @*" mode="{$datacat}" />
				</XSL:template>
				<XSL:template match="node() | @*" mode="{$datacat}" priority="-1000">
					<XSL:copy>
						<XSL:apply-templates select="node() | @*" mode="{$datacat}"/>
					</XSL:copy>
				</XSL:template>
				<xsl:if test="datc:localAdding">
					<xsl:call-template name="localMarkupTemplate"/>
				</xsl:if>
			</xsl:for-each>
		</XSL:stylesheet>
	</xsl:template>
	<xsl:template name="localMarkupTemplate">
		<XSL:template match="{datc:localAdding/@datcatSelector}" mode="{$datacat}" priority="+1000">
			<XSL:copy>
				<XSL:apply-templates mode="{@name}" select="@*"/>
				<itsElementAnnotation datacat="{$datacat}">
					<XSL:for-each select="{datc:localAdding/@addedMarkup}">
						<XSL:copy-of select="."/>
					</XSL:for-each>
				</itsElementAnnotation>
				<XSL:apply-templates mode="{@name}" select="node()"/>
			</XSL:copy>
		</XSL:template>
	</xsl:template>
</xsl:stylesheet>
