<xsl:stylesheet xmlns:its="http://www.w3.org/2005/11/its" 
	xmlns:itsx="http://www.w3.org/2008/12/its-extensions"
	xmlns:datc="http://example.com/datacats"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:XSL="http://www.w3.org/1999/XSL/TransformAlias" exclude-result-prefixes="xsl datc"
	xmlns:xlink="http://www.w3.org/1999/xlink" version="1.0">
	<xsl:output method="xml" indent="yes" encoding="utf-8"/>
	<xsl:strip-space elements="*"/>
	<xsl:namespace-alias stylesheet-prefix="XSL" result-prefix="xsl"/>
	<xsl:param name="inputfile"/>
	<xsl:param name="datacat"/>
	<xsl:param name="rulesElement"
		select="document('sampleCatDesc.xml')//datc:datacat[@name=$datacat]/datc:rulesElement/@name"/>
	<xsl:template match="/">
		<!-- Write general stylesheet stuff -->
		<XSL:stylesheet version="1.0" xmlns:its="http://www.w3.org/2005/11/its" 	xmlns:itsx="http://www.w3.org/2008/12/its-extensions"
			xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
			<XSL:output method="xml" indent="yes" encoding="utf-8"/>
			<xsl:for-each select="//datc:datacat[@name=$datacat]">
				<XSL:template match="/">
					<XSL:apply-templates select="*" mode="{$datacat}" />
				</XSL:template>
				<XSL:template match="*" mode="{$datacat}" priority="-1000">
					<XSL:copy>
                                        <XSL:copy-of select="@*"/>
						<XSL:apply-templates select="* | @*" mode="{$datacat}"/>
					</XSL:copy>
				</XSL:template>
	<XSL:template match="itsInfo" mode="{$datacat}" priority="+1000">
					<XSL:copy-of select="self::*"/>
				</XSL:template>
				<xsl:if test="datc:rulesElement">
					<xsl:call-template name="globalRulesTemplate"/>
				</xsl:if>
			</xsl:for-each>
		</XSL:stylesheet>
	</xsl:template>
	<xsl:template name="globalRulesTemplate">
		<!-- 
		problems: ns  -->
		<XSL:template mode="{$datacat}" match="@*"/>
		<xsl:for-each
			select="document('rules.xml')//*[name()=$rulesElement or local-name()=$rulesElement or concat('its:',local-name())=$rulesElement or concat('itsx:',local-name())=$rulesElement]">
			<xsl:variable name="priority">
				<xsl:number/>
			</xsl:variable>
			<xsl:for-each select="@*[contains(name(),'Pointer')]">
				<XSL:template mode="{concat($datacat,name(.))}" match="node() | @*">
					<xsl:attribute name="priority">
						<xsl:value-of select="$priority"/>
					</xsl:attribute>
					<XSL:copy>
						<XSL:apply-templates select="@* | node()" mode="{concat($datacat,name(.))}"
						/>
					</XSL:copy>
				</XSL:template>
			</xsl:for-each>
			<XSL:template mode="{$datacat}" match="{@selector}">
				<xsl:attribute name="priority">
					<xsl:number/>
				</xsl:attribute>
				<xsl:for-each
					select="namespace::*
					[not(.='http://www.w3.org/XML/1998/namespace')]">
					<xsl:variable name="ns">
						<xsl:value-of select="."/>
					</xsl:variable>
					<xsl:variable name="nsprefix">
						<xsl:value-of select="name()"/>
					</xsl:variable>
					<xsl:variable name="no">
						<xsl:number/>
					</xsl:variable>
					<xsl:attribute name="{concat($nsprefix,':','dummy_for_its_',$no)}"
						namespace="{$ns}">
						<xsl:value-of select="$ns"/>
					</xsl:attribute>
				</xsl:for-each>
				<XSL:choose>
					<XSL:when test="self::*">
						<XSL:copy>
							<XSL:copy-of select="@*"/>
							<XSL:apply-templates mode="{$datacat}" select="@*"/>
<XSL:if test="not(child::ElementAnnotation[@datacat='{$datacat}'])">
							<itsElementAnnotation  datacat="{$datacat}">
								<xsl:copy-of
									select="@*[not(name()='selector')][not(contains(name(),'Pointer'))] | node()"/>
								<xsl:for-each select="@*[contains(name(),'Pointer')]">
									<xsl:element name="{name(.)}">
										<XSL:apply-templates select="{.}"
											mode="{concat($datacat,name(.))}"/>
									</xsl:element>
								</xsl:for-each>
							</itsElementAnnotation>
</XSL:if>
							<XSL:apply-templates mode="{$datacat}" select="*"/>	
						</XSL:copy>
					</XSL:when>
					<XSL:otherwise>
						<itsAttributeAnnotation attribute="{{name()}}" datacat="{$datacat}">
							<xsl:copy-of
								select="@*[not(name()='selector')][not(contains(name(),'Pointer'))] | node()"/>
							<xsl:for-each select="@*[contains(name(),'Pointer')]">
								<xsl:element name="{name(.)}">
									<XSL:apply-templates select="{.}"
										mode="{concat($datacat,name(.))}"/>
								</xsl:element>
							</xsl:for-each>
						</itsAttributeAnnotation>
					</XSL:otherwise>
				</XSL:choose>
			</XSL:template>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
